/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.bases.equitable.items;

import java.util.List;
import java.util.function.Consumer;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.equitable.EquitableTypes;
import zombieworldproject.zombieracore.managers.item.bases.equitable.ZEEquipmentsManager;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsableItemBase;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;

public class EquitableItemBase
extends UsableItemBase {
    public final Integer nbtId;
    public final String dirName;
    public final String displayName;
    public final EquitableTypes type;
    public final String rarity;
    public final Integer dropWeight;
    public final Double armor;
    public final Double radProtection;
    public final Double walkSpeed;
    public final Double scratchArmor;
    public final Double biteArmor;
    public final Double sneakDistance;
    public final Integer maxDurability;
    public ItemStack thisItem;

    public EquitableItemBase(String dirName, String displayName, Integer ntbId, EquitableTypes type, String rarity, Integer dropWeight, Double armor, Double radProtection, Double walkSpeed, Double scratchArmor, Double biteArmor, Double sneakDistance, Integer maxDurability) {
        super(displayName, ntbId, rarity, dropWeight, dirName);
        this.dirName = dirName;
        this.displayName = displayName;
        this.dropWeight = dropWeight;
        this.nbtId = ntbId;
        this.type = type;
        this.armor = armor;
        this.rarity = rarity;
        this.radProtection = radProtection;
        this.walkSpeed = walkSpeed;
        this.scratchArmor = scratchArmor;
        this.biteArmor = biteArmor;
        this.sneakDistance = sneakDistance;
        this.maxDurability = maxDurability;
        ZombiEraCore.getItemManager().equipmentItems.put(ntbId, this);
    }

    @Override
    public void playerItemUseByEvent(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        PlayerInventory playerInventory = player.getInventory();
        ZEEquipmentsManager.EquipmentInventory equipmentInventory = ZEEquipmentsManager.playerEquipmentInventories.get(player);
        if (!event.getAction().isRightClick() || equipmentInventory == null) {
            return;
        }
        ItemStack itemInHand = playerInventory.getItemInMainHand();
        switch (this.type) {
            case HEAD: {
                this.equipArmorPiece(player, playerInventory.getHelmet(), itemInHand, slotItem -> playerInventory.setHelmet(slotItem), "head");
                break;
            }
            case CHEST: {
                this.equipArmorPiece(player, playerInventory.getChestplate(), itemInHand, slotItem -> playerInventory.setChestplate(slotItem), "chest");
                break;
            }
        }
        equipmentInventory.setItems();
    }

    private void equipArmorPiece(Player player, ItemStack equippedItem, ItemStack newItem, Consumer<ItemStack> equipAction, String bodyPart) {
        if (equippedItem == null) {
            equipAction.accept(newItem);
            player.getInventory().setItemInMainHand(null);
        } else {
            ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Something's already on " + bodyPart + "!", 5);
        }
    }

    @Override
    public Integer getNBTTag() {
        return this.id;
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.SKULL_BANNER_PATTERN);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        meta.setDisplayName(String.valueOf(ZombiEraCore.getRarityDropManager().getColor(this.rarity)) + this.displayName);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Equipment");
        lore.add(ItemUtils.generatedurability(this.maxDurability, this.maxDurability));
        this.addStatLore(lore, "Armor", this.armor);
        this.addStatLore(lore, "Scratch Armor", this.scratchArmor);
        this.addStatLore(lore, "Bite Armor", this.biteArmor);
        this.addStatLore(lore, "Sneak", this.sneakDistance);
        if (this.radProtection > 0.0) {
            lore.add(String.valueOf(ChatColor.YELLOW) + "\u2623" + String.valueOf(ChatColor.GREEN) + " Anti-radiation" + String.valueOf(ChatColor.YELLOW) + " \u2623" + String.valueOf(ChatColor.WHITE) + ": <" + this.radProtection + ">");
        }
        if (this.walkSpeed != 0.0) {
            lore.add(String.valueOf(ChatColor.WHITE) + "Speed Modifier: " + this.walkSpeed + " %");
        }
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Usage:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right click in hand to equip!");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Left click in armor slot to un-equip!");
        meta.setLore(lore);
        meta.setCustomModelData(this.nbtId);
        if (this.walkSpeed != 0.0) {
            meta.addAttributeModifier(Attribute.GENERIC_MOVEMENT_SPEED, new AttributeModifier("generic.movementSpeed", this.walkSpeed / 100.0, AttributeModifier.Operation.ADD_SCALAR));
        }
        item.setItemMeta(meta);
        return item;
    }

    private void addStatLore(List<String> lore, String label, Double value) {
        if (value != null && value > 0.0) {
            lore.add(String.valueOf(ChatColor.WHITE) + label + " <" + value + ">");
        }
    }
}

