/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.bases.food;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsableItemBase;
import zombieworldproject.zombieracore.managers.player.states.HealthStates;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class CannedFoodItemBase
extends UsableItemBase {
    public String nameOpened;
    public String nameClosed;
    public Integer nbtOpened;
    public Integer nbtClosed;
    public Boolean drink;
    public Integer rotten_chance;
    public Integer hunger;
    public Integer water;
    public ItemStack itemClosed;
    public ItemStack itemOpened;
    public String dirNameClosed;
    public Float saturationLevel;

    public CannedFoodItemBase(String dirName, String nameOpened, String nameClosed, Integer nbtOpened, Integer nbtClosed, Boolean drink, Integer rotten, Integer hunger, Integer water, String rarity, Integer dropWeight, Float saturationLevel) {
        super(dirName, nbtOpened, true);
        this.dirName = dirName;
        this.nameOpened = nameOpened;
        this.nameClosed = nameClosed;
        this.nbtOpened = nbtOpened;
        this.nbtClosed = nbtClosed;
        this.dropWeight = dropWeight;
        this.drink = drink;
        this.rotten_chance = rotten;
        this.hunger = hunger;
        this.water = water;
        this.saturationLevel = saturationLevel;
        this.itemClosed = this.createItem(false);
        this.itemOpened = this.createItem(true);
        this.rarity = rarity;
        this.dirNameClosed = dirName + "_closed";
        ZombiEraCore.getItemManager().cannedFoodItems.put(this.dirNameClosed, this);
        this.createRecipe();
    }

    @Override
    public String getRarity() {
        return this.rarity;
    }

    @Override
    public Integer getDropWeight() {
        return this.dropWeight;
    }

    private void createRecipe() {
        try {
            NamespacedKey key = new NamespacedKey("zombieworld", this.dirNameClosed + "openrecipe");
            ShapedRecipe recipe = new ShapedRecipe(key, this.getItem(true));
            recipe.shape(new String[]{"ES"});
            recipe.setIngredient('E', this.getItem(false));
            recipe.setIngredient('S', ZombiEraCore.getItemManager().usableItems.get("canopener").getItem());
            ZombiEraCore.getRecipeManager().addRecipe(recipe);
            Bukkit.addRecipe((Recipe)recipe);
            ZombiEraCore.debugInfo("Registered recipe for Canned Food Item: " + this.dirNameClosed);
        }
        catch (Exception e) {
            ZombiEraCore.debugInfo("Could not register recipe for Canned Food Item: " + this.dirNameClosed + ". Please restart server!");
        }
    }

    public ItemStack getItem(boolean opened) {
        ItemStack thisItem = opened ? this.itemOpened : this.itemClosed;
        return thisItem;
    }

    public ItemStack createItem(boolean opened) {
        ItemStack item = opened ? (this.drink.booleanValue() ? new ItemStack(Material.HONEY_BOTTLE) : new ItemStack(Material.APPLE)) : new ItemStack(Material.CREEPER_BANNER_PATTERN);
        ItemMeta itemMeta = item.getItemMeta();
        String thisName = opened ? this.nameOpened : this.nameClosed;
        itemMeta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.rarity), thisName));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        if (this.drink.booleanValue()) {
            lore.add(String.valueOf(ChatColor.BLUE) + "Drinkable");
        } else {
            lore.add(String.valueOf(ChatColor.BLUE) + "Edible");
        }
        lore.add(String.valueOf(ChatColor.WHITE) + "Hunger: <" + this.hunger + ">");
        lore.add(String.valueOf(ChatColor.WHITE) + "Water: <" + this.water + ">");
        lore.add(String.valueOf(ChatColor.WHITE) + "Saturation: <" + this.saturationLevel + ">");
        if (this.rotten_chance > 0) {
            lore.add(String.valueOf(ChatColor.DARK_GREEN) + "Rotten");
        }
        itemMeta.setLore(lore);
        if (opened) {
            itemMeta.setCustomModelData(this.nbtOpened);
        } else {
            itemMeta.setCustomModelData(this.nbtClosed);
        }
        item.setItemMeta(itemMeta);
        return item;
    }

    @Override
    public void playerItemUseByEvent(PlayerInteractEvent event) {
    }

    @Override
    public void playerItemUseByEvent(PlayerItemConsumeEvent event) {
        event.setReplacement(null);
        event.setCancelled(true);
        Player player = event.getPlayer();
        if (this.rotten_chance > 0 && MiscUtils.generateChance(this.rotten_chance)) {
            ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player).setSickness(HealthStates.STOMACH_SICKNESS, true);
        }
        if (this.hunger > 0) {
            int newFoodLevel = player.getFoodLevel() + this.hunger;
            if (newFoodLevel >= 20) {
                player.setFoodLevel(20);
            } else {
                player.setFoodLevel(Math.max(newFoodLevel, 0));
            }
        }
        if (this.water != 0) {
            ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player).addWater(this.water);
        }
        if (this.saturationLevel.floatValue() > 0.0f) {
            player.setSaturation(Math.min(player.getSaturation() + this.saturationLevel.floatValue(), 20.0f));
        }
        PlayerInventory playerInv = player.getInventory();
        ItemStack main = playerInv.getItemInMainHand();
        ItemStack off = playerInv.getItemInOffHand();
        if (main.hasItemMeta() && main.getItemMeta().hasCustomModelData() && main.getItemMeta().getCustomModelData() == this.nbtOpened.intValue()) {
            if (main.getAmount() == 0) {
                playerInv.setItemInMainHand(null);
            } else {
                main.setAmount(main.getAmount() - 1);
                playerInv.setItemInMainHand(main);
            }
        } else if (off.hasItemMeta() && off.getItemMeta().hasCustomModelData() && off.getItemMeta().getCustomModelData() == this.nbtOpened.intValue()) {
            if (off.getAmount() == 0) {
                playerInv.setItemInOffHand(null);
            } else {
                off.setAmount(off.getAmount() - 1);
                playerInv.setItemInOffHand(off);
            }
        }
    }

    @Override
    public String getDirName() {
        return this.dirName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getNBTTag() {
        return this.nbtClosed;
    }

    @Override
    public ItemStack getItem() {
        return null;
    }

    @Override
    public ItemStack createItem() {
        return null;
    }
}

