/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.bases.food;

import java.util.List;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsableItemBase;
import zombieworldproject.zombieracore.managers.player.states.HealthStates;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class FoodItemBase
extends UsableItemBase {
    public Boolean drink;
    public Integer rotten_chance;
    public Integer hunger;
    public Integer water;
    public Boolean stackable;
    public Float saturationLevel;

    public FoodItemBase(String itemGiveId, String name, Integer id, Boolean drink, Integer rotten, Integer hunger, Integer water, String rarity, Boolean stackable, Integer dropWeight, Float saturationLevel) {
        super(name, id, rarity, dropWeight, itemGiveId);
        this.drink = drink;
        this.rotten_chance = rotten;
        this.hunger = hunger;
        this.water = water;
        this.stackable = stackable;
        this.saturationLevel = saturationLevel;
        ZombiEraCore.getItemManager().foodItems.put(itemGiveId, this);
    }

    @Override
    public ItemStack getItem() {
        if (this.thisItem == null) {
            this.thisItem = this.createItem();
        }
        ItemMeta meta = this.thisItem.getItemMeta();
        List lore = meta.getLore();
        if (!this.stackable.booleanValue()) {
            for (int i = 0; i < lore.size(); ++i) {
                if (!((String)lore.get(i)).contains("$")) continue;
                lore.set(i, "\u00a7" + String.valueOf(new Random().nextDouble()).replace(".", "$"));
                meta.setLore(lore);
                this.thisItem.setItemMeta(meta);
                break;
            }
        }
        return this.thisItem;
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = this.drink != false ? new ItemStack(Material.HONEY_BOTTLE) : new ItemStack(Material.APPLE);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.rarity), this.name));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        if (this.drink.booleanValue()) {
            lore.add(String.valueOf(ChatColor.BLUE) + "Drinkable");
        } else {
            lore.add(String.valueOf(ChatColor.BLUE) + "Edible");
        }
        lore.add(String.valueOf(ChatColor.WHITE) + "Hunger: <" + this.hunger + ">");
        lore.add(String.valueOf(ChatColor.WHITE) + "Water: <" + this.water + ">");
        lore.add(String.valueOf(ChatColor.WHITE) + "Saturation: <" + this.saturationLevel + ">");
        if (this.rotten_chance > 0) {
            lore.add(String.valueOf(ChatColor.DARK_GREEN) + "Rotten");
        }
        if (!this.stackable.booleanValue()) {
            lore.add("\u00a7" + String.valueOf(new Random().nextDouble()).replace(".", "$"));
        }
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(this.id);
        item.setItemMeta(itemMeta);
        return item;
    }

    @Override
    public void playerItemUseByEvent(PlayerItemConsumeEvent event) {
        event.setReplacement(null);
        event.setCancelled(true);
        Player player = event.getPlayer();
        if (this.rotten_chance > 0 && MiscUtils.generateChance(this.rotten_chance)) {
            ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player).setSickness(HealthStates.STOMACH_SICKNESS, true);
        }
        if (this.hunger > 0) {
            int newFoodLevel = player.getFoodLevel() + this.hunger;
            if (newFoodLevel >= 20) {
                player.setFoodLevel(20);
            } else {
                player.setFoodLevel(Math.max(newFoodLevel, 0));
            }
        }
        if (this.water != 0) {
            ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player).addWater(this.water);
        }
        if (this.saturationLevel.floatValue() > 0.0f) {
            player.setSaturation(Math.min(player.getSaturation() + this.saturationLevel.floatValue(), 20.0f));
        }
        PlayerInventory playerInv = player.getInventory();
        ItemStack main = playerInv.getItemInMainHand();
        ItemStack off = playerInv.getItemInOffHand();
        if (main.hasItemMeta() && main.getItemMeta().hasCustomModelData() && main.getItemMeta().getCustomModelData() == this.getNBTTag().intValue()) {
            playerInv.setItemInMainHand(null);
        } else if (off.hasItemMeta() && off.getItemMeta().hasCustomModelData() && off.getItemMeta().getCustomModelData() == this.getNBTTag().intValue()) {
            playerInv.setItemInOffHand(null);
        }
    }
}

