/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.bases.gun;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.ItemBase;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.AmmoTypes;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.handlers.BulletShootHandler;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.handlers.FlameThrowerShootHandler;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsableItemBase;
import zombieworldproject.zombieracore.managers.item.builtIn.ammo.AmmoItem;
import zombieworldproject.zombieracore.managers.item.stats.BonusStats;
import zombieworldproject.zombieracore.managers.item.stats.ZEBonusStats;
import zombieworldproject.zombieracore.managers.player.states.PlayerHealth;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class ArmedGunItemBase
extends UsableItemBase {
    private final BulletShootHandler shootHandler;
    public Integer maxDurability;
    public Double damage;
    public Integer shootDelayTicks;
    public Double bulletVelocity;
    public Integer nbtZoomId;
    public Double recoilX;
    public Double recoilY;
    public Integer dropWeight;
    public AmmoTypes ammoType;
    public Integer maxAmmo;
    public String dirName;
    public Integer reloadInTicks;
    public String fireSound;
    public String reloadSound;
    public Double maxRangeDamage;
    public Double headMultiplier;
    public Double bodyMultiplier;
    public Double legMultiplier;
    public Integer scopeNbtId;
    public Integer sprintNbtId;
    public Integer zoomMultiplier;
    public ItemStack scopeItem;
    public Double walkSlowness;
    public Integer equipTicks;
    public BonusStats bonusStats;

    public ArmedGunItemBase(String dirName, String name, Integer id, Integer zoomId, Integer durability, Double damage, Integer shootDelayTicks, String rarity, Double bulletVelocity, Double recoilX, Double recoilY, Integer dropWeight, Integer maxAmmo, AmmoTypes ammoType, Integer reloadInTicks, String fireSound, String reloadSound, Double maxRangeDamage, Double headMultiplier, Double bodyMultiplier, Double legMultiplier, Integer scopeNbtId, Integer zoomMultiplier, Integer sprintNbtId, Double walkSlowness, Integer equipTicks, BonusStats bonusStats) {
        super(name, id, rarity, dropWeight, dirName);
        this.nbtZoomId = zoomId;
        this.maxDurability = durability;
        this.damage = damage;
        this.shootDelayTicks = shootDelayTicks;
        this.bulletVelocity = bulletVelocity;
        this.recoilX = recoilX;
        this.recoilY = recoilY;
        this.ammoType = ammoType;
        this.maxAmmo = maxAmmo;
        this.reloadInTicks = reloadInTicks;
        this.fireSound = fireSound;
        this.reloadSound = reloadSound;
        this.maxRangeDamage = maxRangeDamage;
        this.headMultiplier = headMultiplier;
        this.bodyMultiplier = bodyMultiplier;
        this.legMultiplier = legMultiplier;
        this.scopeNbtId = scopeNbtId;
        this.zoomMultiplier = zoomMultiplier;
        this.sprintNbtId = sprintNbtId;
        this.shootHandler = ZombiEraCore.getItemManager().getShootHandler(this.ammoType);
        this.walkSlowness = walkSlowness;
        this.equipTicks = equipTicks;
        this.bonusStats = bonusStats;
        ZombiEraCore.getItemManager().armedItems.put(id, this);
        ZombiEraCore.getItemManager().armedItems.put(zoomId, this);
        ZombiEraCore.getItemManager().armedItems.put(sprintNbtId, this);
    }

    public void setLook(Player player) {
        Location playerLoc = player.getLocation();
        playerLoc.setYaw(playerLoc.getYaw() + this.recoilY.floatValue() * (float)MiscUtils.randomNegativePositiveInt().intValue());
        playerLoc.setPitch(playerLoc.getPitch() - this.recoilX.floatValue());
        Entity entity = player.getPassenger();
        if (entity != null) {
            player.removePassenger(entity);
        }
        player.teleport(playerLoc, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public String displayName() {
        return String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.rarity), this.getName());
    }

    @Override
    public ItemStack getItem() {
        if (this.thisItem == null) {
            this.thisItem = this.createItem();
        }
        ItemUtils.setCapacity(this.thisItem, MiscUtils.generateBetweenNumbers(1, this.maxAmmo));
        ItemUtils.setDurability(this.thisItem, MiscUtils.generateBetweenNumbers(this.maxDurability / 3, this.maxDurability));
        ZEBonusStats.setBonusStats(this.thisItem, this.bonusStats, this.displayName());
        return this.thisItem;
    }

    public BulletShootHandler getShootHandler() {
        return this.shootHandler;
    }

    public ItemStack getScopeItem() {
        if (this.scopeItem == null) {
            this.scopeItem = this.createScopeItem();
        }
        return this.scopeItem;
    }

    public ItemStack createScopeItem() {
        ItemStack item = new ItemStack(Material.CREEPER_BANNER_PATTERN);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName("Scope Item");
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        itemMeta.setCustomModelData(this.scopeNbtId);
        item.setItemMeta(itemMeta);
        return item;
    }

    public boolean reloadGun(final Player player, final ItemStack gunItem) {
        if (ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player).isUsingItem().booleanValue()) {
            return false;
        }
        final PlayerHealth ph = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
        Boolean isEquipping = (Boolean)ph.getDataStorage().getData("isEquipping");
        if (isEquipping != null && isEquipping.booleanValue()) {
            return false;
        }
        Integer bullets = (Integer)ph.getDataStorage().getData("g_cap");
        if (bullets != null) {
            ItemUtils.setCapacity(gunItem, bullets);
        }
        if (ItemUtils.getCapacity(gunItem).equals(this.maxAmmo)) {
            ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), String.format("Gun's magazine is full!", this.ammoType.toString()), 5);
            return false;
        }
        ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player).startUsingItem();
        final PlayerInventory playerInv = player.getInventory();
        final Integer nbtId = gunItem.getItemMeta().getCustomModelData();
        final int[] count = new int[]{0};
        boolean hasAmmo = false;
        for (int i = 0; i <= 35; ++i) {
            ItemBase itemBase;
            ItemStack item = playerInv.getItem(i);
            if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasCustomModelData() || !((itemBase = ZombiEraCore.getItemManager().ammoTypesNBTIds.get(item.getItemMeta().getCustomModelData())) != null & itemBase instanceof AmmoItem)) continue;
            AmmoItem ammoItem = (AmmoItem)itemBase;
            if (ammoItem.ammoType != this.ammoType) continue;
            hasAmmo = true;
            break;
        }
        if (!hasAmmo) {
            ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), String.format("Can't reload! No %s ammo", this.ammoType.toString()), 5);
            ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player).stopUsingItem();
            return false;
        }
        ZombiEraCore.getSoundManager().playSound(player.getLocation(), this.reloadSound);
        new BukkitRunnable(){

            public void run() {
                ItemMeta metaNow;
                Integer nbtNow = null;
                ItemStack itemNow = playerInv.getItemInMainHand();
                if (itemNow.hasItemMeta() && (metaNow = itemNow.getItemMeta()).hasCustomModelData()) {
                    nbtNow = metaNow.getCustomModelData();
                }
                if (nbtNow == null || !nbtNow.equals(nbtId) || !ph.isUsingItem().booleanValue()) {
                    ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Reload interrupted!", 5);
                    ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player).stopUsingItem();
                    player.playSound(player.getLocation(), Sound.BLOCK_CANDLE_HIT, 1.0f, 1.0f);
                    ZombiEraCore.getSoundManager().stopSoundAtPlayer(player, ArmedGunItemBase.this.reloadSound);
                    this.cancel();
                } else {
                    ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Reloading.." + ".".repeat(Math.round(count[0] / 10)), 5);
                    count[0] = count[0] + 1;
                    if (count[0] == ArmedGunItemBase.this.reloadInTicks) {
                        int bulletsNow = ItemUtils.getCapacity(gunItem);
                        for (int i = 0; i <= 35; ++i) {
                            ItemBase itemBase;
                            ItemStack item = playerInv.getItem(i);
                            if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasCustomModelData() || !((itemBase = ZombiEraCore.getItemManager().ammoTypesNBTIds.get(item.getItemMeta().getCustomModelData())) != null & itemBase instanceof AmmoItem)) continue;
                            AmmoItem ammoItem = (AmmoItem)itemBase;
                            if (ammoItem.ammoType != ArmedGunItemBase.this.ammoType) continue;
                            int itemAmount = item.getAmount();
                            int minusAmount = 0;
                            int amountPlus = bulletsNow + itemAmount;
                            if (amountPlus > ArmedGunItemBase.this.maxAmmo) {
                                minusAmount = ArmedGunItemBase.this.maxAmmo - bulletsNow;
                                item.setAmount(item.getAmount() - minusAmount);
                                bulletsNow = ArmedGunItemBase.this.maxAmmo;
                                if (item.getAmount() > 0) {
                                    playerInv.setItem(i, item);
                                    break;
                                }
                                playerInv.setItem(i, null);
                                break;
                            }
                            minusAmount = amountPlus - bulletsNow;
                            bulletsNow = amountPlus;
                            item.setAmount(item.getAmount() - minusAmount);
                            if (item.getAmount() > 0) {
                                playerInv.setItem(i, item);
                                continue;
                            }
                            playerInv.setItem(i, null);
                        }
                        ItemUtils.setCapacity(itemNow, bulletsNow);
                        ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Reloaded!", 5);
                        ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player).stopUsingItem();
                        ZombiEraCore.getSoundManager().stopSoundAtPlayer(player, ArmedGunItemBase.this.reloadSound);
                        Integer checkBullets = (Integer)ph.getDataStorage().getData("g_cap");
                        if (checkBullets != null) {
                            ph.getDataStorage().setData("g_cap", bulletsNow);
                        }
                        this.cancel();
                    }
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 1L, 1L);
        return true;
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.CREEPER_BANNER_PATTERN);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(this.displayName());
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Armed Gun");
        lore.add(ItemUtils.generatedurability(this.maxDurability, this.maxDurability));
        lore.add(String.valueOf(ChatColor.WHITE) + "Capacity: (" + this.maxAmmo + ")");
        lore.add(String.valueOf(ChatColor.WHITE) + "Max: <" + this.maxAmmo + ">");
        lore.add("");
        lore.add(String.valueOf(ChatColor.AQUA) + "Ammo: " + String.valueOf(ChatColor.WHITE) + this.ammoType.toString());
        lore.add(String.valueOf(ChatColor.WHITE) + "Damage: <" + this.damage + ">");
        lore.add(String.valueOf(ChatColor.WHITE) + "Multipliers:");
        lore.add(String.valueOf(ChatColor.WHITE) + "    Head: " + this.headMultiplier);
        lore.add(String.valueOf(ChatColor.WHITE) + "    Body: " + this.bodyMultiplier);
        lore.add(String.valueOf(ChatColor.WHITE) + "    Leg: " + this.legMultiplier);
        if (this.walkSlowness != 0.0) {
            lore.add(String.valueOf(ChatColor.WHITE) + "Speed Modifier: " + this.walkSlowness + " %");
        }
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Usage:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right click to shoot.");
        if (this.walkSlowness != 0.0) {
            itemMeta.addAttributeModifier(Attribute.GENERIC_MOVEMENT_SPEED, new AttributeModifier("generic.movementSpeed", this.walkSlowness / 100.0, AttributeModifier.Operation.ADD_SCALAR));
        }
        if (this.ammoType != AmmoTypes.FLAMETHROWER) {
            lore.add(String.valueOf(ChatColor.YELLOW) + "Right click in inventory to unload!");
        } else {
            lore.add(String.valueOf(ChatColor.YELLOW) + "Left click air to pour gasoline in!");
        }
        lore.add(String.valueOf(ChatColor.YELLOW) + "F to reload.");
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(this.id);
        item.setItemMeta(itemMeta);
        return item;
    }

    @Override
    public void handlePlayerItemHeldEvent(final Player player, Boolean swapIn, final ItemStack gunItem) {
        final PlayerHealth ph = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
        if (swapIn.booleanValue()) {
            new BukkitRunnable(){

                public void run() {
                    Integer bullets = ItemUtils.getCapacity(gunItem);
                    Integer durability = ItemUtils.getDurability(gunItem);
                    ph.getDataStorage().setData("g_cap", bullets);
                    ph.getDataStorage().setData("g_dur", durability);
                    if (!ZombiEraCore.ZEPlayerManagers.getGunsManager().fireLocked.contains(player)) {
                        ZombiEraCore.ZEPlayerManagers.getGunsManager().fireLocked.add(player);
                    }
                    ph.getDataStorage().setData("isEquipping", true);
                    ZombiEraCore.getSoundManager().playSound(player, "equip");
                    new BukkitRunnable(){
                        int counter = 0;

                        public void run() {
                            Boolean isEquipping = (Boolean)ph.getDataStorage().getData("isEquipping");
                            if (isEquipping == null) {
                                isEquipping = false;
                            }
                            if (isEquipping.booleanValue() && this.counter < ArmedGunItemBase.this.equipTicks) {
                                ++this.counter;
                                ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Equipping.." + ".".repeat(this.counter % 2), 5);
                            } else if (isEquipping.booleanValue()) {
                                ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Equipped!", 5);
                                ph.getDataStorage().setData("isEquipping", false);
                                ZombiEraCore.ZEPlayerManagers.getGunsManager().fireLocked.remove(player);
                                this.cancel();
                            } else {
                                ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Equip has been canceled!", 5);
                                ph.getDataStorage().setData("isEquipping", false);
                                ZombiEraCore.ZEPlayerManagers.getGunsManager().fireLocked.remove(player);
                                this.cancel();
                            }
                        }
                    }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 1L);
                }
            }.runTaskLater((Plugin)ZombiEraCore.instance, 1L);
        } else {
            Integer bullets = (Integer)ph.getDataStorage().getData("g_cap");
            Integer durability = (Integer)ph.getDataStorage().getData("g_dur");
            if (bullets != null) {
                ItemUtils.setCapacity(gunItem, bullets);
                ph.getDataStorage().clearData("g_cap");
            }
            if (durability != null) {
                ItemUtils.setDurability(gunItem, durability);
                ph.getDataStorage().clearData("g_dur");
            }
            ph.getDataStorage().setData("isEquipping", false);
        }
    }

    @Override
    public void playerOpenInventoryEvent(Player player, ItemStack itemStack) {
        ZombiEraCore.debugInfo("open inv");
        PlayerHealth ph = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
        Integer bullets = (Integer)ph.getDataStorage().getData("g_cap");
        Integer durability = (Integer)ph.getDataStorage().getData("g_dur");
        if (bullets != null) {
            ItemUtils.setCapacity(itemStack, bullets);
        }
        if (durability != null) {
            ItemUtils.setDurability(itemStack, durability);
        }
    }

    @Override
    public void playerSwapItemEvent(PlayerSwapHandItemsEvent event, UsableItemBase usableItemBase, ItemStack itemStack, boolean isMainHand) {
        if (!isMainHand) {
            event.setCancelled(true);
            this.reloadGun(event.getPlayer(), itemStack);
        }
    }

    @Override
    public void playerItemUseByEvent(PlayerInteractEvent event) {
        final Player player = event.getPlayer();
        if (player.isSprinting()) {
            ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Can't interact while sprinting!", 5);
            return;
        }
        Location loc = player.getLocation();
        loc.add(0.0, -1.5, 0.0);
        ItemStack gunItem = player.getInventory().getItemInMainHand();
        if (event.getAction().isLeftClick()) {
            ZombiEraCore.debugInfo("Here");
            this.shootHandler.leftClick(player, this, gunItem);
            return;
        }
        Vector vector = player.getVelocity();
        PlayerHealth ph = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
        Integer bullets = (Integer)ph.getDataStorage().getData("g_cap");
        Integer durability = (Integer)ph.getDataStorage().getData("g_dur");
        if (bullets == null) {
            bullets = ItemUtils.getCapacity(gunItem);
            ph.getDataStorage().setData("g_cap", bullets);
        }
        if (durability == null) {
            durability = ItemUtils.getDurability(gunItem);
            ph.getDataStorage().setData("g_dur", durability);
        }
        if (durability == 0) {
            ZombiEraCore.getSoundManager().playSound(player, "melee_broken");
            ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Item is broken!", 5);
            return;
        }
        if ((double)durability.intValue() < (double)this.maxDurability.intValue() / 2.75 && MiscUtils.generateChange(47.0f)) {
            ZombiEraCore.getSoundManager().playSound(player, "gunjam");
            return;
        }
        if (this.shootHandler instanceof FlameThrowerShootHandler && bullets == 0) {
            ItemUtils.setCapacity(gunItem, 0);
            ItemUtils.refillGasItem(player, gunItem, this.maxAmmo);
            return;
        }
        if (bullets == 0) {
            ItemUtils.setCapacity(gunItem, 0);
            if (!this.reloadGun(player, gunItem)) {
                ZombiEraCore.getSoundManager().playSound(player, "empty_magazine");
            }
            return;
        }
        if (event.getAction().isRightClick() && vector.getY() < 0.5 && vector.getY() > -0.08) {
            if (!ZombiEraCore.ZEPlayerManagers.getGunsManager().fireLocked.contains(player)) {
                this.shootHandler.shootGun(player, this, gunItem);
                ZombiEraCore.ZEPlayerManagers.getGunsManager().fireLocked.add(player);
                new BukkitRunnable(){

                    public void run() {
                        ZombiEraCore.ZEPlayerManagers.getGunsManager().fireLocked.remove(player);
                        this.cancel();
                    }
                }.runTaskLater((Plugin)ZombiEraCore.instance, (long)this.shootDelayTicks.intValue());
            } else {
                return;
            }
        }
        ph.getDataStorage().setData("g_cap", bullets - 1);
        ph.getDataStorage().setData("g_dur", durability - 1);
        ZombiEraCore.getCombatLogManager().logCombat(player);
    }
}

