/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.bases.gun;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.ItemBase;
import zombieworldproject.zombieracore.managers.item.bases.gun.ArmedGunItemBase;
import zombieworldproject.zombieracore.managers.item.bases.gun.ScopedGunInfo;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.Bullet;

public class ZEGunManager {
    private final Map<Player, ScopedGunInfo> zoomedPlayers = new HashMap<Player, ScopedGunInfo>();
    private final List<Player> sprintAnimation = new ArrayList<Player>();
    public Map<Integer, Bullet> uniqueIds = new HashMap<Integer, Bullet>();
    public List<Player> fireLocked = new ArrayList<Player>();
    public List<Player> meleeLocked = new ArrayList<Player>();

    public void zoomPlayer(Player player, ArmedGunItemBase gun) {
        if (!this.zoomedPlayers.containsKey(player)) {
            this.zoomedPlayers.put(player, new ScopedGunInfo(player, gun, player.getInventory().getItemInOffHand()));
            if (gun.zoomMultiplier > 0) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, Integer.MAX_VALUE, gun.zoomMultiplier * -1));
            }
            if (gun.scopeNbtId != 0) {
                player.getInventory().setItemInOffHand(gun.getScopeItem());
            }
        }
    }

    public boolean isSprintAnimationEnabled(Player player) {
        return this.sprintAnimation.contains(player);
    }

    public ScopedGunInfo getZoomedPlayer(Player player) {
        return this.zoomedPlayers.get(player);
    }

    public void sprintGunAnimation(boolean sprinting, Player player) {
        int id;
        ItemBase itemBase;
        PlayerInventory playerInventory = player.getInventory();
        ItemStack handItem = playerInventory.getItemInMainHand();
        if (handItem != null && handItem.hasItemMeta() && handItem.getItemMeta().hasCustomModelData() && !this.zoomedPlayers.containsKey(player) && (itemBase = (ItemBase)ZombiEraCore.getItemManager().armedItems.get(id = handItem.getItemMeta().getCustomModelData())) instanceof ArmedGunItemBase) {
            ArmedGunItemBase gunItemBase = (ArmedGunItemBase)itemBase;
            if (sprinting) {
                ItemMeta meta = handItem.getItemMeta();
                meta.setCustomModelData(gunItemBase.sprintNbtId);
                handItem.setItemMeta(meta);
                player.getInventory().setItemInMainHand(handItem);
                if (!this.sprintAnimation.contains(player)) {
                    this.sprintAnimation.add(player);
                }
            } else {
                ItemMeta meta = handItem.getItemMeta();
                meta.setCustomModelData(gunItemBase.id);
                handItem.setItemMeta(meta);
                player.getInventory().setItemInMainHand(handItem);
                this.sprintAnimation.remove(player);
            }
        }
    }

    public void unZoomPlayer(Player player) {
        ScopedGunInfo sInfo = this.zoomedPlayers.get(player);
        if (sInfo != null) {
            if (sInfo.gun.zoomMultiplier > 0) {
                player.removePotionEffect(PotionEffectType.SPEED);
            }
            if (sInfo.gun.scopeNbtId != 0) {
                player.getInventory().setItemInOffHand(sInfo.lastOffHandItem);
            }
        }
        this.zoomedPlayers.remove(player);
    }

    public void setAllZoomedGunsToUnzoomed(Player player) {
        ScopedGunInfo sInfo = ZombiEraCore.ZEPlayerManagers.getGunsManager().getZoomedPlayer(player);
        if (sInfo != null || this.isSprintAnimationEnabled(player)) {
            PlayerInventory playerInv = player.getInventory();
            for (int i = 0; i <= 35; ++i) {
                int id;
                ItemBase itemBase;
                ItemStack item = playerInv.getItem(i);
                if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasCustomModelData() || (itemBase = (ItemBase)ZombiEraCore.getItemManager().armedItems.get(id = item.getItemMeta().getCustomModelData())) == null) continue;
                ArmedGunItemBase armedGunItemBase = (ArmedGunItemBase)itemBase;
                if (!armedGunItemBase.nbtZoomId.equals(id) && !armedGunItemBase.sprintNbtId.equals(id)) continue;
                ItemMeta meta = item.getItemMeta();
                meta.setCustomModelData(armedGunItemBase.id);
                item.setItemMeta(meta);
                playerInv.setItem(i, item);
                this.sprintAnimation.remove(player);
            }
            ZombiEraCore.ZEPlayerManagers.getGunsManager().unZoomPlayer(player);
        }
    }
}

