/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.bases.gun.bullet;

import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.gun.ArmedGunItemBase;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.BodyPart;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.BulletResult;
import zombieworldproject.zombieracore.managers.props.data.PropData;

public class Bullet {
    public ArmedGunItemBase gun;
    public Location startLoc;
    public Player player;
    public PropData propData;
    public ItemStack gunItem;

    public Bullet(ArmedGunItemBase gun, Player player, ItemStack gunItem) {
        this.startLoc = player.getLocation().clone();
        this.gun = gun;
        this.player = player;
        this.gunItem = gunItem;
    }

    public Bullet(ArmedGunItemBase gun, PropData pd) {
        this.startLoc = pd.getLocation().clone();
        this.gun = gun;
        this.player = null;
        this.propData = pd;
    }

    public BulletResult getBulletMultiplier(Entity hitEntity, Entity projectile, Bullet bullet) {
        if (hitEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)hitEntity;
            if (projectile instanceof Projectile) {
                Double bodyLocationMultiplier;
                BodyPart bodyPart;
                Vector impactPoint;
                Projectile proj = (Projectile)projectile;
                BoundingBox entityBoundingBox = livingEntity.getBoundingBox();
                Vector entityCenter = entityBoundingBox.getCenter();
                Vector difference = entityCenter.subtract(impactPoint = proj.getLocation().toVector());
                if (Math.abs(difference.getY()) > entityBoundingBox.getHeight() / 2.5) {
                    bullet.PlayHeadshotSound();
                    bodyPart = BodyPart.HEAD;
                    ZombiEraCore.debugInfo("Head");
                    bodyLocationMultiplier = this.gun.headMultiplier;
                } else if (Math.abs(difference.getY()) < entityBoundingBox.getHeight() / 2.5 && Math.abs(difference.getY()) > entityBoundingBox.getHeight() / 3.45) {
                    bodyPart = BodyPart.BODY;
                    ZombiEraCore.debugInfo("Body");
                    bodyLocationMultiplier = this.gun.bodyMultiplier;
                } else {
                    bodyPart = BodyPart.LEG;
                    ZombiEraCore.debugInfo("LEG");
                    bodyLocationMultiplier = this.gun.legMultiplier;
                }
                Double bulletToHitDistance = this.startLoc.distance(hitEntity.getLocation());
                Double rangeMultiplier = 1.0 - bulletToHitDistance / this.gun.maxRangeDamage / 10.0;
                Double totalMultiplier = this.gun.damage * bodyLocationMultiplier * rangeMultiplier;
                return new BulletResult(this, totalMultiplier, bodyPart);
            }
        }
        return new BulletResult(this, 1.0, BodyPart.BODY);
    }

    public void PlayHeadshotSound() {
        if (this.player != null && this.player.isOnline()) {
            ZombiEraCore.getSoundManager().playSound(this.player, "headshot");
        }
    }
}

