/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.bases.gun.bullet.handlers;

import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.gun.ArmedGunItemBase;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.Bullet;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.handlers.BulletShootHandler;

public class EnergyShootHandler
implements BulletShootHandler {
    @Override
    public void shootGun(Player player, ArmedGunItemBase gunItemBase, ItemStack itemStackGun) {
        final Snowball bullet = (Snowball)player.getWorld().spawn(player.getEyeLocation(), Snowball.class, snowball -> {
            ItemStack item = snowball.getItem();
            ItemMeta meta = item.getItemMeta();
            meta.setCustomModelData(Integer.valueOf(271));
            item.setItemMeta(meta);
            snowball.setItem(item);
        });
        Vector velocity = player.getLocation().getDirection().multiply(gunItemBase.bulletVelocity.doubleValue());
        bullet.setVelocity(velocity);
        ZombiEraCore.ZEPlayerManagers.getGunsManager().uniqueIds.put(bullet.getEntityId(), new Bullet(gunItemBase, player, itemStackGun));
        new BukkitRunnable(){

            public void run() {
                if (bullet.isValid()) {
                    bullet.getWorld().spawnParticle(Particle.REDSTONE, bullet.getLocation(), 0, 0.001, 1.0, 0.0, 1.0, (Object)new Particle.DustOptions(Color.WHITE, 2.0f));
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 1L);
        ZombiEraCore.getSoundManager().playGunFireSound(player, gunItemBase.fireSound);
        gunItemBase.setLook(player);
        this.rayGunEffect(player, 20, 5.0);
    }

    public void rayGunEffect(Player player, int length, double thickness) {
        Location startLocation = player.getEyeLocation();
        Vector direction = startLocation.getDirection().normalize();
        for (int i = 0; i < length; ++i) {
            double x = startLocation.getX() + direction.getX() * (double)i;
            double y = startLocation.getY() + direction.getY() * (double)i;
            double z = startLocation.getZ() + direction.getZ() * (double)i;
            Location particleLoc = new Location(startLocation.getWorld(), x, y, z);
            player.getWorld().spawnParticle(Particle.REDSTONE, particleLoc, (int)(thickness * thickness), 0.0, 0.0, 0.0, 1.0, (Object)new Particle.DustOptions(Color.GREEN, 1.0f));
        }
    }
}

