/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.bases.gun.bullet.handlers;

import java.util.List;
import java.util.Random;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.ZombiEraSettings;
import zombieworldproject.zombieracore.managers.item.bases.equitable.ZEEquipmentsManager;
import zombieworldproject.zombieracore.managers.item.bases.gun.ArmedGunItemBase;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.handlers.BulletShootHandler;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class FlameThrowerShootHandler
implements BulletShootHandler {
    @Override
    public void shootGun(Player player, ArmedGunItemBase gunItemBase, ItemStack itemStackGun) {
        Random rand = new Random();
        boolean allow = true;
        if (ZombiEraSettings.CHECK_FOR_FLAMETHROWER.booleanValue()) {
            ZEEquipmentsManager.EquipmentInventory equipInv = ZEEquipmentsManager.playerEquipmentInventories.get(player);
            if (equipInv == null) {
                allow = false;
            }
            if (allow) {
                ItemStack item = equipInv.getChest();
                if (item != null && item.hasItemMeta() && item.getItemMeta().hasCustomModelData()) {
                    if (item.getItemMeta().getCustomModelData() != ZombiEraSettings.FLAMETHROWER_BACKPACK_NBT_ID.intValue()) {
                        allow = false;
                    }
                } else {
                    allow = false;
                }
            }
        }
        if (!allow) {
            ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Flamethrower Backpack required!", 5);
            return;
        }
        Particle.DustTransition dustTransition = new Particle.DustTransition(Color.fromRGB((int)50, (int)50, (int)50), Color.fromRGB((int)100, (int)100, (int)100), 0.75f);
        Vector direction = player.getLocation().getDirection().normalize();
        Vector directionOrg = direction.clone();
        direction = direction.multiply(1);
        direction.setY(direction.getY() + 1.45);
        direction.setY(direction.getY() - 0.8);
        direction = direction.multiply(2);
        Location pos2 = player.getLocation().add(direction);
        for (int i = 0; i < 1 + rand.nextInt(5); ++i) {
            Vector flamesDir = directionOrg.clone();
            flamesDir = flamesDir.multiply(rand.nextFloat() * 5.0f + 2.0f);
            Location flamesPos = player.getLocation().add(flamesDir);
            flamesPos = flamesPos.add(0.0, 1.5, 0.0);
            for (int j = 0; j < 1 + rand.nextInt(2); ++j) {
                Location flamesPosFinal = flamesPos.clone();
                flamesPosFinal = flamesPosFinal.add((double)(rand.nextFloat() * 0.5f * (float)MiscUtils.randomNegativePositiveInt().intValue()), (double)(rand.nextFloat() * 0.5f * (float)MiscUtils.randomNegativePositiveInt().intValue()), (double)(rand.nextFloat() * 0.5f * (float)MiscUtils.randomNegativePositiveInt().intValue()));
                player.getWorld().spawnParticle(Particle.FLAME, flamesPosFinal, 1, 0.01, 0.01, 0.01, 0.001);
                player.getWorld().playSound(player.getLocation(), Sound.BLOCK_SAND_STEP, 0.75f, 1.4f);
            }
        }
        List lineOfSight = player.getLineOfSight(null, 10);
        for (Block b : lineOfSight) {
            if (b.isSolid() && b.getRelative(BlockFace.UP).getType() == Material.AIR) {
                b.getRelative(BlockFace.UP).setType(Material.FIRE);
                continue;
            }
            if (b.isSolid() || !b.getRelative(BlockFace.DOWN).isSolid()) continue;
            b.setType(Material.FIRE);
        }
        gunItemBase.setLook(player);
        if (MiscUtils.generateChance(50)) {
            player.getWorld().spawnParticle(Particle.FLAME, pos2, 1, 0.01, 0.01, 0.01, 0.001);
        }
    }

    @Override
    public void leftClick(Player player, ArmedGunItemBase gunItemBase, ItemStack itemStackGun) {
        Integer bullets = ItemUtils.getCapacity(itemStackGun);
        if (bullets < gunItemBase.maxAmmo) {
            ItemUtils.refillGasItem(player, itemStackGun, gunItemBase.maxAmmo);
        }
    }
}

