/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.bases.gun.bullet.handlers;

import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.gun.ArmedGunItemBase;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.Bullet;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.BulletResult;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.handlers.BulletShootHandler;

public class GrenadeShootHandler
implements BulletShootHandler {
    @Override
    public void shootGun(Player player, ArmedGunItemBase gunItemBase, ItemStack itemStackGun) {
        Snowball bullet = (Snowball)player.getWorld().spawn(player.getEyeLocation(), Snowball.class, snowball -> {
            ItemStack item = snowball.getItem();
            ItemMeta meta = item.getItemMeta();
            meta.setCustomModelData(Integer.valueOf(270));
            item.setItemMeta(meta);
            snowball.setItem(item);
        });
        Vector velocity = player.getLocation().getDirection().multiply(gunItemBase.bulletVelocity.doubleValue());
        bullet.setVelocity(velocity);
        ZombiEraCore.ZEPlayerManagers.getGunsManager().uniqueIds.put(bullet.getEntityId(), new Bullet(gunItemBase, player, itemStackGun));
        Particle.DustTransition dustTransition = new Particle.DustTransition(Color.fromRGB((int)50, (int)50, (int)50), Color.fromRGB((int)100, (int)100, (int)100), 0.75f);
        Vector direction = player.getLocation().getDirection().normalize();
        direction = direction.multiply(1);
        direction.setY(direction.getY() + 1.45);
        Location pos = player.getLocation().add(direction);
        ZombiEraCore.getSoundManager().playGunFireSound(player, gunItemBase.fireSound);
        player.getWorld().spawnParticle(Particle.DUST_COLOR_TRANSITION, pos, 2, (Object)dustTransition);
        gunItemBase.setLook(player);
    }

    @Override
    public void onProjectileHit(Location location) {
        location.createExplosion(3.0f, false, false);
        location.createExplosion(0.5f, false, false);
        location.createExplosion(0.5f, false, false);
    }

    @Override
    public void onProjectileHit(Entity entity, BulletResult result) {
        this.onProjectileHit(entity.getLocation());
    }
}

