/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.bases.gun.bullet.handlers;

import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.gun.ArmedGunItemBase;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.Bullet;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.handlers.BulletShootHandler;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class NormalShootHandler
implements BulletShootHandler {
    @Override
    public void shootGun(Player player, ArmedGunItemBase gunItemBase, ItemStack itemStackGun) {
        final Snowball bullet = (Snowball)player.getWorld().spawn(player.getEyeLocation(), Snowball.class, snowball -> {
            ItemStack item = snowball.getItem();
            ItemMeta meta = item.getItemMeta();
            meta.setCustomModelData(Integer.valueOf(271));
            item.setItemMeta(meta);
            snowball.setItem(item);
        });
        Vector velocity = player.getLocation().getDirection().multiply(gunItemBase.bulletVelocity.doubleValue());
        bullet.setVelocity(velocity);
        ZombiEraCore.ZEPlayerManagers.getGunsManager().uniqueIds.put(bullet.getEntityId(), new Bullet(gunItemBase, player, itemStackGun));
        new BukkitRunnable(){

            public void run() {
                if (bullet.isValid()) {
                    bullet.getWorld().spawnParticle(Particle.REDSTONE, bullet.getLocation(), 0, 0.001, 1.0, 0.0, 1.0, (Object)new Particle.DustOptions(Color.WHITE, 2.0f));
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 1L);
        final Block playerBlock = player.getWorld().getBlockAt(player.getLocation()).getRelative(BlockFace.UP);
        if (playerBlock.getType() == Material.AIR) {
            playerBlock.setType(Material.LIGHT);
            Levelled level = (Levelled)playerBlock.getBlockData();
            level.setLevel(9);
            playerBlock.setBlockData((BlockData)level, true);
            new BukkitRunnable(){

                public void run() {
                    playerBlock.setType(Material.AIR);
                }
            }.runTaskLater((Plugin)ZombiEraCore.instance, 3L);
        }
        Particle.DustTransition dustTransition = new Particle.DustTransition(Color.fromRGB((int)50, (int)50, (int)50), Color.fromRGB((int)100, (int)100, (int)100), 0.75f);
        Vector direction = player.getLocation().getDirection().normalize();
        direction = direction.multiply(1);
        direction.setY(direction.getY() + 1.45);
        Location pos = player.getLocation().add(direction);
        direction.setY(direction.getY() - 0.8);
        direction = direction.multiply(2);
        Location pos2 = player.getLocation().add(direction);
        ZombiEraCore.getSoundManager().playGunFireSound(player, gunItemBase.fireSound);
        player.getWorld().spawnParticle(Particle.DUST_COLOR_TRANSITION, pos, 2, (Object)dustTransition);
        gunItemBase.setLook(player);
        if (MiscUtils.generateChance(50)) {
            player.getWorld().spawnParticle(Particle.FLAME, pos2, 1, 0.01, 0.01, 0.01, 0.001);
        }
    }

    @Override
    public void shootTurret(PropData pd) {
        Location loc1 = pd.getArmorStand().getEyeLocation().add(0.0, -1.0, 0.0);
        final Snowball bullet = (Snowball)pd.getLocation().getWorld().spawn(loc1, Snowball.class, snowball -> {
            ItemStack item = snowball.getItem();
            ItemMeta meta = item.getItemMeta();
            meta.setCustomModelData(Integer.valueOf(271));
            item.setItemMeta(meta);
            snowball.setItem(item);
        });
        Vector velocity = pd.getLocation().clone().getDirection().multiply(5.0);
        bullet.setVelocity(velocity);
        ZombiEraCore.ZEPlayerManagers.getGunsManager().uniqueIds.put(bullet.getEntityId(), new Bullet((ArmedGunItemBase)ZombiEraCore.getItemManager().getItemBase("ak47"), pd));
        new BukkitRunnable(){

            public void run() {
                if (bullet.isValid()) {
                    bullet.getWorld().spawnParticle(Particle.REDSTONE, bullet.getLocation(), 0, 0.001, 1.0, 0.0, 1.0, (Object)new Particle.DustOptions(Color.WHITE, 2.0f));
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 1L);
        final Block playerBlock = pd.getLocation().getWorld().getBlockAt(pd.getLocation()).getRelative(BlockFace.UP);
        if (playerBlock.getType() == Material.AIR) {
            playerBlock.setType(Material.LIGHT);
            Levelled level = (Levelled)playerBlock.getBlockData();
            level.setLevel(9);
            playerBlock.setBlockData((BlockData)level, true);
            new BukkitRunnable(){

                public void run() {
                    playerBlock.setType(Material.AIR);
                }
            }.runTaskLater((Plugin)ZombiEraCore.instance, 3L);
        }
        Particle.DustTransition dustTransition = new Particle.DustTransition(Color.fromRGB((int)50, (int)50, (int)50), Color.fromRGB((int)100, (int)100, (int)100), 0.75f);
        Vector direction = pd.getLocation().getDirection().normalize();
        direction = direction.multiply(1);
        direction.setY(direction.getY() + 1.45);
        Location pos = pd.getLocation().add(direction);
        direction.setY(direction.getY() - 0.8);
        direction = direction.multiply(2);
        Location pos2 = pd.getLocation().add(direction);
        ZombiEraCore.getSoundManager().playSound(pd.getLocation(), "m249_shot", (Double)50.0);
        pd.getLocation().getWorld().spawnParticle(Particle.DUST_COLOR_TRANSITION, pos, 2, (Object)dustTransition);
        if (MiscUtils.generateChance(50)) {
            pd.getLocation().getWorld().spawnParticle(Particle.FLAME, pos2, 1, 0.01, 0.01, 0.01, 0.001);
        }
    }
}

