/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.bases.melee;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.melee.MeleeUpgradeHandler;
import zombieworldproject.zombieracore.managers.item.bases.melee.ZEMeleeManager;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsableItemBase;
import zombieworldproject.zombieracore.managers.item.stats.BonusStats;
import zombieworldproject.zombieracore.managers.item.stats.ZEBonusStats;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class MeleeItemBase
extends UsableItemBase {
    public String name;
    public String dirName;
    public Integer id;
    public Double attackDamage;
    public Integer maxDurability;
    public ItemStack thisItem = null;
    public String rarity;
    public Integer dropWeight;
    public Double attackSpeed;
    public List<MeleeUpgradeHandler> meleeHandlers;
    public BonusStats bonusStats;

    public MeleeItemBase(String itemGiveId, String name, Integer id, Double attackDamage, Integer maxDurability, String rarity, Integer dropWeight, Double attackSpeed, List<MeleeUpgradeHandler> meleeHandlers, BonusStats bonusStats) {
        super(name, id, rarity, dropWeight, itemGiveId);
        this.name = name;
        this.id = id;
        this.attackDamage = attackDamage;
        this.maxDurability = maxDurability;
        this.rarity = rarity;
        this.dropWeight = dropWeight;
        this.dirName = itemGiveId;
        this.attackSpeed = attackSpeed;
        this.meleeHandlers = meleeHandlers;
        this.bonusStats = bonusStats;
        ZombiEraCore.getItemManager().meleeWeapons.put(itemGiveId, this);
    }

    @Override
    public void handlePlayerItemHeldEvent(Player player, Boolean swapIn, ItemStack item) {
        if (swapIn.booleanValue()) {
            ZEMeleeManager.startMeleeEffect(player, this);
        } else {
            ZEMeleeManager.stopMeleeEffect(player, this);
        }
    }

    public void playMeleeEffects(Player player) {
        for (MeleeUpgradeHandler handler : this.meleeHandlers) {
            handler.playEffects(player);
        }
    }

    public void playerHitsEntity(Player player, Entity entity) {
        for (MeleeUpgradeHandler handler : this.meleeHandlers) {
            handler.applyEntityHit(player, entity);
        }
    }

    @Override
    public String getRarity() {
        return this.rarity;
    }

    @Override
    public Integer getDropWeight() {
        return this.dropWeight;
    }

    @Override
    public String getDirName() {
        return this.dirName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getNBTTag() {
        return this.id;
    }

    @Override
    public ItemStack getItem() {
        ItemStack itemStack = this.createItem();
        ItemUtils.setDurability(itemStack, MiscUtils.generateBetweenNumbers(this.maxDurability / 3, this.maxDurability));
        ZEBonusStats.setBonusStats(itemStack, this.bonusStats, this.displayName());
        return itemStack;
    }

    public String displayName() {
        return String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.rarity), this.name);
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.IRON_AXE);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setAttributeModifiers(null);
        AttributeModifier modifier1 = new AttributeModifier("generic.attack_speed", this.attackSpeed.doubleValue(), AttributeModifier.Operation.ADD_NUMBER);
        itemMeta.addAttributeModifier(Attribute.GENERIC_ATTACK_SPEED, modifier1);
        AttributeModifier modifier2 = new AttributeModifier("generic.attack_damage", this.attackDamage.doubleValue(), AttributeModifier.Operation.ADD_NUMBER);
        itemMeta.addAttributeModifier(Attribute.GENERIC_ATTACK_DAMAGE, modifier2);
        itemMeta.setDisplayName(this.displayName());
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        itemMeta.setUnbreakable(true);
        List<String> lore = ItemUtils.getItemLore();
        lore.add(ItemUtils.generatedurability(this.maxDurability, this.maxDurability));
        lore.add(String.valueOf(ChatColor.WHITE) + "Attack-damage: <" + this.attackDamage + ">");
        lore.add(String.valueOf(ChatColor.WHITE) + "Attack-speed:  <" + this.attackSpeed + ">");
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(this.id);
        item.setItemMeta(itemMeta);
        return item;
    }
}

