/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.bases.melee;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.melee.MeleeItemBase;
import zombieworldproject.zombieracore.managers.item.bases.melee.MeleeUpgradeHandler;
import zombieworldproject.zombieracore.managers.item.bases.melee.MeleeUpgradeTypes;
import zombieworldproject.zombieracore.managers.item.bases.melee.handlers.ElectricalMeleeHandler;
import zombieworldproject.zombieracore.managers.item.bases.melee.handlers.FireMeleeHandler;
import zombieworldproject.zombieracore.managers.item.bases.melee.handlers.PoisonMeleeHandler;

public final class ZEMeleeManager {
    private static final Map<MeleeUpgradeTypes, MeleeUpgradeHandler> meleeHandlers = new HashMap<MeleeUpgradeTypes, MeleeUpgradeHandler>(){
        {
            this.put(MeleeUpgradeTypes.ELECTRIC, new ElectricalMeleeHandler());
            this.put(MeleeUpgradeTypes.POISON, new PoisonMeleeHandler());
            this.put(MeleeUpgradeTypes.FIRE, new FireMeleeHandler());
        }
    };
    private static final Map<Player, BukkitTask> runnableHashMap = new HashMap<Player, BukkitTask>();

    private ZEMeleeManager() {
    }

    public static void startMeleeEffect(final Player player, final MeleeItemBase base) {
        if (player == null || base == null || runnableHashMap.containsKey(player)) {
            return;
        }
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                if (this.isCancelled()) {
                    return;
                }
                ItemStack item = player.getInventory().getItemInMainHand();
                if (item != null && item.hasItemMeta() && item.getItemMeta().hasCustomModelData() && item.getItemMeta().getCustomModelData() == base.id.intValue()) {
                    base.playMeleeEffects(player);
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 15L);
        runnableHashMap.put(player, task);
    }

    public static void stopMeleeEffect(Player player, MeleeItemBase base) {
        if (player == null) {
            return;
        }
        BukkitTask task = runnableHashMap.remove(player);
        if (task != null) {
            task.cancel();
        }
    }

    public static MeleeUpgradeHandler getHandler(MeleeUpgradeTypes type) {
        return meleeHandlers.get((Object)type);
    }
}

