/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.bases.melee.handlers;

import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.melee.MeleeUpgradeHandler;

public class ElectricalMeleeHandler
implements MeleeUpgradeHandler {
    @Override
    public void applyEntityHit(Player player, final Entity entity) {
        final LivingEntity livingEntity = (LivingEntity)entity;
        new BukkitRunnable(){
            int count = 0;

            public void run() {
                if (livingEntity.isValid()) {
                    livingEntity.damage(4.0);
                    ZombiEraCore.getSoundManager().playSound(entity.getLocation(), "taser_fire");
                    ++this.count;
                    if (livingEntity.getNearbyEntities(2.0, 2.0, 2.0).size() > 0) {
                        for (Entity nearbyEntity : livingEntity.getNearbyEntities(2.0, 2.0, 2.0)) {
                            if (!(nearbyEntity instanceof LivingEntity) || nearbyEntity.getType().equals((Object)EntityType.PLAYER)) continue;
                            ((LivingEntity)nearbyEntity).damage(1.0);
                        }
                    }
                } else {
                    this.cancel();
                    return;
                }
                if (this.count > 4) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 20L);
    }

    @Override
    public void playEffects(Player player) {
        ZombiEraCore.getSoundManager().playSound(player.getLocation(), "being_tased");
        player.getWorld().spawnParticle(Particle.FIREWORKS_SPARK, this.getRightHandParticleLocation(player), 20, 0.0, 0.0, 0.0, 0.0);
    }
}

