/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.bases.usable;

import com.google.errorprone.annotations.ForOverride;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.ItemMeta;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.ItemBase;

public abstract class UsableItemBase
implements ItemBase {
    public String name;
    public String dirName;
    public Integer id;
    public ItemStack thisItem = null;
    public String rarity = "default";
    public Integer dropWeight = 1;
    HashMap<String, Object> metaData = new HashMap();

    public UsableItemBase(String name, Integer id) {
        this.init(name, id);
    }

    public UsableItemBase(String name, Integer id, Boolean createRarity) {
        this.init(name, id, createRarity);
    }

    public UsableItemBase(String name, Integer id, String rarity) {
        this.init(name, id);
        this.rarity = rarity;
    }

    public UsableItemBase(String name, Integer id, String rarity, Integer dropWeight, String dirName) {
        this.init(name, id);
        this.rarity = rarity;
        this.dirName = dirName;
        this.dropWeight = dropWeight;
    }

    public static boolean isSameItem(int usableId, PlayerInventory playerInv) {
        int id = 0;
        ItemStack item = playerInv.getItemInMainHand();
        boolean cancel = false;
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta != null && itemMeta.hasCustomModelData()) {
            id = itemMeta.getCustomModelData();
        }
        if (id != usableId) {
            cancel = true;
        }
        return cancel;
    }

    public void setMetaData(String name, Object object) {
        this.metaData.put(name, object);
    }

    public Object getMetaData(String name) {
        return this.metaData.get(name);
    }

    private void init(String name, Integer id) {
        this.init(name, id, false);
    }

    private void init(String name, Integer id, Boolean createRarity) {
        this.name = name;
        this.id = id;
        this.dirName = name.replace(" ", "").toLowerCase();
        ZombiEraCore.getItemManager().usableItems.put(this.dirName, this);
        if (createRarity.booleanValue()) {
            this.rarity = this.dirName;
        }
        this.addRecipe();
    }

    public void addRecipe() {
        Recipe recipe = this.getRecipe();
        if (recipe != null) {
            try {
                Bukkit.addRecipe((Recipe)this.getRecipe());
            }
            catch (Exception e) {
                ZombiEraCore.debugInfo("Recipe couldn't be loaded! Duplicate! Restart the server.");
            }
        }
    }

    public Recipe getRecipe() {
        return null;
    }

    public void playerItemHeldEvent(Player player, Boolean swapIn, ItemStack item) {
        ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player).stopUsingItem();
        this.handlePlayerItemHeldEvent(player, swapIn, item);
    }

    @ForOverride
    public void handlePlayerItemHeldEvent(Player player, Boolean swapIn, ItemStack item) {
    }

    @ForOverride
    public void playerOpenInventoryEvent(Player player, ItemStack itemStack) {
    }

    @ForOverride
    public void playerItemUseByEvent(PlayerInteractEvent event) {
    }

    @ForOverride
    public void playerItemUseByEvent(PlayerItemConsumeEvent event) {
    }

    @ForOverride
    public void playerSwapItemEvent(PlayerSwapHandItemsEvent event, UsableItemBase usableItemBase, ItemStack itemStack, boolean isMainHand) {
    }

    @Override
    public String getRarity() {
        return this.rarity;
    }

    @Override
    public Integer getDropWeight() {
        return this.dropWeight;
    }

    @Override
    public String getDirName() {
        return this.dirName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ItemStack getItem() {
        if (this.thisItem == null) {
            this.thisItem = this.createItem();
        }
        return this.thisItem;
    }

    @Override
    public Integer getNBTTag() {
        return this.id;
    }
}

