/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.bases.usable;

import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import zombieworldproject.zombieracore.ZombiEraCore;

public class UsingItemSession {
    private final Integer maxTicks;
    private final Integer usedItemNbt;
    private final Player player;
    private final PlayerInventory playerInventory;
    private Boolean isDone = false;
    private Boolean interrupted = false;
    private Integer ticksNow = 0;
    private Integer slowness = 0;

    public UsingItemSession(Player player, Integer maxTicks, Integer usedItemNbt) {
        this.player = player;
        this.playerInventory = player.getInventory();
        this.maxTicks = maxTicks;
        this.usedItemNbt = usedItemNbt;
    }

    public UsingItemSession(Player player, Integer maxTicks, Integer usedItemNbt, Integer slowness) {
        this.player = player;
        this.playerInventory = player.getInventory();
        this.maxTicks = maxTicks;
        this.usedItemNbt = usedItemNbt;
        this.slowness = slowness;
    }

    public Boolean isSameItem() {
        ItemStack itemNow = this.playerInventory.getItemInMainHand();
        return itemNow.hasItemMeta() && itemNow.getItemMeta().hasCustomModelData() && itemNow.getItemMeta().getCustomModelData() == this.usedItemNbt.intValue();
    }

    public void tick() {
        if (this.isDone.booleanValue()) {
            return;
        }
        ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(this.player).startUsingItem();
        if (this.ticksNow < this.maxTicks && this.isSameItem().booleanValue()) {
            this.ticksNow = this.ticksNow + 1;
            if (this.ticksNow % 5 == 0) {
                ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(this.player.getName(), "Using..." + ".".repeat(this.ticksNow % 2), 5);
                if (this.slowness > 0) {
                    this.player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 6, this.slowness.intValue()));
                }
            }
        } else if (!this.isSameItem().booleanValue()) {
            this.isDone = true;
            this.interrupted = true;
            ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(this.player).stopUsingItem();
            ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(this.player.getName(), "Action interrupted!", 5);
            this.player.getWorld().playSound(this.player.getLocation(), Sound.BLOCK_CANDLE_HIT, 1.0f, 1.0f);
        } else {
            this.player.getInventory().setItemInMainHand(null);
            this.player.getWorld().playSound(this.player.getLocation(), Sound.UI_TOAST_OUT, 1.0f, 1.0f);
            this.interrupted = false;
            this.isDone = true;
            ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(this.player).stopUsingItem();
        }
    }

    public Boolean isDone() {
        return this.isDone;
    }

    public Boolean isInterrupted() {
        return this.interrupted;
    }
}

