/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.builtIn.admin;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.handlers.WorldHandler;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsableItemBase;
import zombieworldproject.zombieracore.misc.other.Vector3;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;
import zombieworldproject.zombieracore.world.PopulatorData;
import zombieworldproject.zombieracore.world.structuremanager.ZEStructureManager;

public class StructureSelector
extends UsableItemBase {
    public StructureSelector() {
        super("Structure Selector", (Integer)0, "admin");
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.STICK);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.rarity), this.getName()));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Admin Tool");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Usage:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Structure selector");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right click block: sel pos1");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Left click block: sel pos2");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right click air: copy sel");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Left click air: paste sel");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Permission: zombiera.admin");
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(this.getNBTTag());
        item.setItemMeta(itemMeta);
        return item;
    }

    @Override
    public void playerItemUseByEvent(PlayerInteractEvent event) {
        final Player player = event.getPlayer();
        if (player.hasPermission("zombiera.admin") && !ZEStructureManager.selectionLock.contains(player)) {
            Block b = event.getClickedBlock();
            if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                Location loc = b.getLocation();
                ZEStructureManager.selectPlayer(player, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), 1);
            } else if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
                Location loc = b.getLocation();
                ZEStructureManager.selectPlayer(player, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), 2);
            } else if (event.getAction() == Action.RIGHT_CLICK_AIR) {
                ZEStructureManager.CopySelection(player);
            } else if (event.getAction() == Action.LEFT_CLICK_AIR) {
                ZEStructureManager.structurePaste(player);
            }
            ZEStructureManager.selectionLock.add(player);
            if (b != null) {
                WorldHandler.instance.blockQueue.add(new PopulatorData.DefaultBlockData(b.getType(), new Vector3(b.getX(), b.getY(), b.getZ()), 0, 0));
            }
            new BukkitRunnable(){

                public void run() {
                    ZEStructureManager.selectionLock.remove(player);
                    this.cancel();
                }
            }.runTaskTimer((Plugin)ZombiEraCore.instance, 10L, 1L);
        }
    }
}

