/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.builtIn.ammo;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.AmmoTypes;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsableItemBase;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsingItemSession;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;

public class AmmoBox
extends UsableItemBase {
    private final Integer ammoCount;
    private final AmmoTypes ammoType;

    public AmmoBox(Integer ammoCount, AmmoTypes type, String name, Integer id) {
        super(name, id, true);
        this.ammoType = type;
        this.ammoCount = ammoCount;
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.CREEPER_BANNER_PATTERN);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.rarity), this.getName()));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Usable");
        lore.add(String.valueOf(ChatColor.WHITE) + "Contains ammo");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Usage:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right click to open.");
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(this.getNBTTag());
        item.setItemMeta(itemMeta);
        return item;
    }

    @Override
    public void playerItemUseByEvent(PlayerInteractEvent event) {
        if (event.getAction().isRightClick() && !ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(event.getPlayer()).isUsingItem().booleanValue()) {
            final Player player = event.getPlayer();
            final UsingItemSession itemSession = new UsingItemSession(player, 40, this.getNBTTag(), 2);
            new BukkitRunnable(){

                public void run() {
                    itemSession.tick();
                    if (itemSession.isDone().booleanValue()) {
                        if (!itemSession.isInterrupted().booleanValue()) {
                            ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Ammo box opened!", 5);
                            ItemStack ammoItem = ZombiEraCore.getItemManager().ammoTypesItems.get((Object)AmmoBox.this.ammoType).getItem().clone();
                            ammoItem.setAmount(AmmoBox.this.ammoCount.intValue());
                            player.getInventory().addItem(new ItemStack[]{ammoItem});
                        }
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)ZombiEraCore.instance, 1L, 1L);
        }
    }
}

