/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.builtIn.ammo;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.AmmoTypes;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsableItemBase;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;

public class AmmoItem
extends UsableItemBase {
    public AmmoTypes ammoType;
    public String displayName;
    public Integer nbtId;
    public String rarity;
    public Integer dropWeight;
    public ItemStack thisItem;

    public AmmoItem(AmmoTypes ammoType, String displayName, Integer nbtId, String rarity, Integer dropWeight) {
        super(displayName, nbtId, rarity);
        this.ammoType = ammoType;
        this.displayName = displayName;
        this.nbtId = nbtId;
        this.rarity = rarity;
        this.dropWeight = dropWeight;
        ZombiEraCore.getItemManager().ammoTypesNBTIds.put(nbtId, this);
    }

    @Override
    public String getName() {
        return this.displayName;
    }

    @Override
    public Integer getNBTTag() {
        return this.nbtId;
    }

    @Override
    public ItemStack getItem() {
        if (this.thisItem == null) {
            this.thisItem = this.createItem();
        }
        return this.thisItem;
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.STICK);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.getRarity()), this.displayName));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Ammo");
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(this.nbtId);
        item.setItemMeta(itemMeta);
        return item;
    }

    @Override
    public String getRarity() {
        return this.rarity;
    }

    @Override
    public Integer getDropWeight() {
        return this.dropWeight;
    }
}

