/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.builtIn.building;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.json.simple.JSONObject;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsableItemBase;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsingItemSession;
import zombieworldproject.zombieracore.managers.item.builtIn.building.BuildHammer;
import zombieworldproject.zombieracore.managers.player.states.PlayerHealth;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.managers.props.handlers.player.LandClaimerProp;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;
import zombieworldproject.zombieracore.remote.database.handlers.DBBlocksHandler;

public class Barricade
extends UsableItemBase {
    public static int nailsRequired = 2;

    public Barricade() {
        super("Barricade", (Integer)2300029, true);
    }

    @Override
    public ItemStack getItem() {
        if (this.thisItem == null) {
            this.thisItem = this.createItem();
        }
        return this.thisItem;
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.CREEPER_BANNER_PATTERN);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.rarity), this.getName()));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Building");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Usage:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right click to place.");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Notes:");
        lore.add(String.valueOf(ChatColor.YELLOW) + String.format("Requires a build hammer and %s nails.", nailsRequired));
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(this.getNBTTag());
        item.setItemMeta(itemMeta);
        return item;
    }

    public boolean playerHasNailsCount(Player player, int count) {
        PlayerInventory inventory = player.getInventory();
        for (ItemStack item : inventory.getContents()) {
            if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasCustomModelData() || !ZombiEraCore.getItemManager().getItemBase(item.getItemMeta().getCustomModelData()).getDirName().equals("nail")) continue;
            if (item.getAmount() >= count) {
                item.setAmount(item.getAmount() - count);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void playerItemUseByEvent(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        final Player player = event.getPlayer();
        PlayerHealth ph = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
        if (ph.isUsingItem().booleanValue()) {
            return;
        }
        ph.startUsingItem(20);
        final PropData pd = LandClaimerProp.isClaimed(player.getLocation());
        if (pd == null) {
            ZombiEraCore.playerInfo(player, "You can't place a barricade within no claimed land!");
            return;
        }
        JSONObject database = (JSONObject)pd.getPropMetaData("database");
        if (database == null) {
            ZombiEraCore.playerInfo(player, "Error. Please try again later. (database is null)");
            return;
        }
        final String playerUUID = (String)database.get((Object)"player");
        if (playerUUID == null) {
            ZombiEraCore.playerInfo(player, "Error. Please try again later. (player is null)");
            return;
        }
        if (!playerUUID.equals(player.getUniqueId().toString())) {
            ZombiEraCore.playerInfo(player, "You can only place blocks within your land!");
            return;
        }
        if (block == null) {
            ZombiEraCore.playerInfo(player, "You can't use a barricade in an air!");
            return;
        }
        if (!block.getType().isSolid()) {
            ZombiEraCore.playerInfo(player, "You can't use a barricade on a non-solid block!");
            return;
        }
        if (!BuildHammer.hasPlayerBuildHammer(player)) {
            ZombiEraCore.playerInfo(player, "You need a build hammer to place a barricade!");
            return;
        }
        final Block blockToPlace = block.getRelative(event.getBlockFace());
        if (!blockToPlace.getType().equals((Object)Material.AIR)) {
            ZombiEraCore.playerInfo(player, "You can't place a barricade here!");
            return;
        }
        if (blockToPlace.getLocation().distance(pd.getLocation()) <= 2.0) {
            ZombiEraCore.playerInfo(player, "You can't place a barricade this close to your land claim!");
            return;
        }
        if (!this.playerHasNailsCount(player, nailsRequired)) {
            ZombiEraCore.playerInfo(player, "You need 2 nails to place a barricade!");
            return;
        }
        final UsingItemSession itemSession = new UsingItemSession(player, 120, this.getNBTTag(), 2);
        ZombiEraCore.getSoundManager().playSound(player.getLocation(), "hammering");
        new BukkitRunnable(){

            public void run() {
                itemSession.tick();
                if (itemSession.isDone().booleanValue()) {
                    if (!itemSession.isInterrupted().booleanValue()) {
                        if (pd.isRemoved()) {
                            ZombiEraCore.playerInfo(player, "You can't place a barricade with no land claim!");
                            this.cancel();
                            return;
                        }
                        ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Barricade placed!", 5);
                        blockToPlace.setType(Material.RED_GLAZED_TERRACOTTA);
                        player.getInventory().setItemInMainHand(null);
                        Location loc = blockToPlace.getLocation();
                        DBBlocksHandler.insertBlock("land", loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), loc.getWorld().getName(), playerUUID);
                    } else {
                        ZombiEraCore.getSoundManager().stopSoundAtPlayer(player, "hammering");
                        ItemStack nail = ZombiEraCore.getItemManager().getItemBase("nail").getItem();
                        nail.setAmount(2);
                        player.getInventory().addItem(new ItemStack[]{nail});
                    }
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 1L, 1L);
    }
}

