/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.builtIn.building;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.json.simple.JSONObject;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsableItemBase;
import zombieworldproject.zombieracore.managers.player.states.PlayerHealth;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.managers.props.handlers.player.LandClaimerProp;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;
import zombieworldproject.zombieracore.remote.database.handlers.DBBlocksHandler;

public class BuildHammer
extends UsableItemBase {
    public BuildHammer() {
        super("Build Hammer", (Integer)2300030, true);
    }

    public static boolean hasPlayerBuildHammer(Player player) {
        ItemStack[] contents;
        PlayerInventory inventory = player.getInventory();
        for (ItemStack item : contents = inventory.getContents()) {
            if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasCustomModelData() || item.getItemMeta().getCustomModelData() != 2300030) continue;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getItem() {
        if (this.thisItem == null) {
            this.thisItem = this.createItem();
        }
        return this.thisItem;
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.CREEPER_BANNER_PATTERN);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.rarity), this.getName()));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Building");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Usage:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right click to pick up build structures. (barricades, storages, etc.)");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Notes:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Can only be used within your claimed land.");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Is required to build structures. (barricades, ...)");
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(this.getNBTTag());
        item.setItemMeta(itemMeta);
        return item;
    }

    @Override
    public void playerItemUseByEvent(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        Player player = event.getPlayer();
        PlayerHealth ph = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
        ZombiEraCore.debugInfo("Player is using build hammer.");
        if (ph.isUsingItem().booleanValue()) {
            return;
        }
        ph.startUsingItem(20);
        PropData pd = LandClaimerProp.isClaimed(player.getLocation());
        if (pd == null) {
            ZombiEraCore.playerInfo(player, "You can't place a barricade within no claimed land!");
            return;
        }
        JSONObject database = (JSONObject)pd.getPropMetaData("database");
        if (database == null) {
            ZombiEraCore.playerInfo(player, "Error. Please try again later. (database is null)");
            return;
        }
        String playerUUID = (String)database.get((Object)"player");
        if (playerUUID == null) {
            ZombiEraCore.playerInfo(player, "Error. Please try again later. (player is null)");
            return;
        }
        if (!playerUUID.equals(player.getUniqueId().toString())) {
            ZombiEraCore.playerInfo(player, "You can only interact with build hammer within your claimed land!");
            return;
        }
        if (block != null && block.getType().equals((Object)Material.RED_GLAZED_TERRACOTTA)) {
            DBBlocksHandler.deleteBlockAt(block.getX(), block.getY(), block.getZ(), block.getWorld().getName());
            block.setType(Material.AIR);
            PlayerInventory inventory = player.getInventory();
            inventory.addItem(new ItemStack[]{ZombiEraCore.getItemManager().getItemBase("barricade").getItem()});
            ItemStack nails = ZombiEraCore.getItemManager().getItemBase("nail").getItem().clone();
            nails.setAmount(2);
            inventory.addItem(new ItemStack[]{nails});
            ZombiEraCore.playerInfo(player, "Barricade taken up!");
        }
    }
}

