/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.builtIn.door.keycards;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Door;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.door.DoorTypes;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsableItemBase;
import zombieworldproject.zombieracore.managers.player.states.PlayerHealth;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;

public class Keycard
extends UsableItemBase {
    DoorTypes keycardType;

    public Keycard(Integer nbtId, String name, DoorTypes keycardType) {
        super(name, nbtId, true);
        this.keycardType = keycardType;
        this.setMetaData("door", true);
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.CREEPER_BANNER_PATTERN);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.rarity), this.getName()));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Usable");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Usage:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right click to open locked door.");
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(this.getNBTTag());
        item.setItemMeta(itemMeta);
        return item;
    }

    @Override
    public void playerItemUseByEvent(final PlayerInteractEvent event) {
        final Block block = event.getClickedBlock();
        final PlayerHealth ph = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(event.getPlayer());
        if (ph.isUsingItem().booleanValue()) {
            return;
        }
        ph.startUsingItem();
        new BukkitRunnable(){

            public void run() {
                ph.stopUsingItem();
            }
        }.runTaskLater((Plugin)ZombiEraCore.instance, 5L);
        if (block == null) {
            return;
        }
        String xyz = String.format("%s_%s_%s", block.getX(), block.getY(), block.getZ());
        if (ZombiEraCore.getDoorManager().doorExists(xyz) && ZombiEraCore.getDoorManager().getDoorType(xyz).equals((Object)this.keycardType)) {
            final Door bd = (Door)block.getBlockData();
            if (bd.isOpen()) {
                ZombiEraCore.playerInfo(event.getPlayer(), "Door is already opened!");
                return;
            }
            ZombiEraCore.playerInfo(event.getPlayer(), String.valueOf(ChatColor.GREEN) + "Successfully opened the door!");
            ZombiEraCore.getSoundManager().playSound(event.getPlayer().getLocation(), "keycard", 2.0f, 1.0f);
            block.getWorld().playSound(block.getLocation(), Sound.BLOCK_IRON_DOOR_OPEN, 1.0f, 1.0f);
            event.getPlayer().getInventory().setItemInMainHand(null);
            bd.setOpen(true);
            block.setBlockData((BlockData)bd);
            final int[] count = new int[]{10};
            new BukkitRunnable(){

                public void run() {
                    ZombiEraCore.playerInfo(event.getPlayer(), String.valueOf(ChatColor.WHITE) + String.format("The door will close in %s secs!", count[0]));
                    if (count[0] == 0 && block.getType().equals((Object)Material.IRON_DOOR)) {
                        if (bd.isOpen()) {
                            block.getWorld().playSound(block.getLocation(), Sound.BLOCK_IRON_DOOR_CLOSE, 1.0f, 1.0f);
                            bd.setOpen(false);
                            block.setBlockData((BlockData)bd);
                        }
                        ZombiEraCore.playerInfo(event.getPlayer(), String.valueOf(ChatColor.WHITE) + String.format("Door closed!", count[0]));
                        this.cancel();
                        return;
                    }
                    count[0] = count[0] - 1;
                }
            }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 20L);
        } else {
            ZombiEraCore.playerInfo(event.getPlayer(), String.valueOf(ChatColor.RED) + "This door is not locked by this keycard!");
        }
    }
}

