/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.builtIn.door.player;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.json.simple.JSONObject;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.door.ZDoor;
import zombieworldproject.zombieracore.managers.door.ZEDoorManager;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsableItemBase;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.managers.props.handlers.player.LandClaimerProp;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;

public class PlayerLock
extends UsableItemBase {
    public PlayerLock() {
        super("Door Lock", (Integer)2300025, true);
        this.setMetaData("door", true);
    }

    @Override
    public ItemStack getItem() {
        if (this.thisItem == null) {
            this.thisItem = this.createItem();
        }
        return this.thisItem;
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.CREEPER_BANNER_PATTERN);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.rarity), this.getName()));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Usable");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Usage:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right click to lock a door for yourself.");
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(this.getNBTTag());
        item.setItemMeta(itemMeta);
        return item;
    }

    @Override
    public void playerItemUseByEvent(PlayerInteractEvent event) {
        ZEDoorManager doorManager = ZombiEraCore.getDoorManager();
        Block doorBlock = event.getClickedBlock();
        ZDoor door = doorManager.getDoor(doorBlock);
        Player player = event.getPlayer();
        if (door == null && !doorBlock.getType().equals((Object)Material.IRON_DOOR)) {
            PropData pd = LandClaimerProp.isClaimed(doorBlock.getLocation());
            if (pd == null) {
                ZombiEraCore.playerInfo(player, "First you need to claim this land!");
                return;
            }
            JSONObject database = (JSONObject)pd.getPropMetaData("database");
            if (database == null) {
                ZombiEraCore.playerInfo(player, "Error, this land claimer has no database metadata!");
                return;
            }
            if (database.get((Object)"player").equals(player.getUniqueId().toString())) {
                PlayerInventory playerInventory = player.getInventory();
                playerInventory.setItemInMainHand(null);
                doorManager.addPlayerDoor(doorBlock, player);
                ZombiEraCore.playerInfo(player, "You locked the door.");
            }
        } else if (doorBlock.getType().equals((Object)Material.IRON_DOOR)) {
            ZombiEraCore.playerInfo(event.getPlayer(), "You can't lock iron door!");
        } else {
            ZombiEraCore.playerInfo(event.getPlayer(), "Door is already locked!");
        }
    }
}

