/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.builtIn.eletric;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.ItemElectricalBase;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsableItemBase;
import zombieworldproject.zombieracore.managers.player.states.ActionStates;
import zombieworldproject.zombieracore.managers.player.states.PlayerHealth;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;

public class Flashlight
extends UsableItemBase
implements ItemElectricalBase {
    public Flashlight() {
        super("FlashLight", (Integer)2300018, true);
    }

    @Override
    public boolean doesNeedBattery() {
        return true;
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.CREEPER_BANNER_PATTERN);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.rarity), this.getName()));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Usable & Electrical");
        lore.add(String.valueOf(ChatColor.WHITE) + "Capacity: (-1)");
        lore.add("");
        lore.add(String.valueOf(ChatColor.WHITE) + "Provides light in dark places.");
        lore.add(String.valueOf(ChatColor.WHITE) + "Needs charged battery!");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Usage:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Left click: take battery out.");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right click: turn on.");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Un-equip: turn off.");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Swap to off hand: turn on");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Note:");
        lore.add(String.valueOf(ChatColor.WHITE) + "-1 -> No battery in.");
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(this.getNBTTag());
        item.setItemMeta(itemMeta);
        return item;
    }

    @Override
    public void playerItemUseByEvent(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        PlayerHealth ph = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
        ItemStack flashLight = player.getInventory().getItemInMainHand();
        int flashLightCap = ItemUtils.getCapacity(flashLight);
        if (ph.isUsingItem().booleanValue()) {
            return;
        }
        if (event.getAction().isRightClick() && flashLightCap > 0) {
            this.turnFlashLightOn(ph, player, flashLight, true);
        } else if (event.getAction().isLeftClick()) {
            this.takeOutBattery(player, flashLight);
        } else if (flashLightCap <= 0) {
            ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Needs charged battery!", 5);
        }
    }

    @Override
    public void playerSwapItemEvent(PlayerSwapHandItemsEvent event, UsableItemBase usableItemBase, ItemStack itemStack, boolean isMainHand) {
        Player player = event.getPlayer();
        PlayerHealth ph = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
        if (!isMainHand && !ph.isUsingItem().booleanValue()) {
            if (ItemUtils.getCapacity(itemStack) > 0) {
                this.turnFlashLightOn(ph, player, itemStack, false);
            }
        } else if (ph.getLastActionState().equals((Object)ActionStates.USED_ELECTRIC_ITEM)) {
            ItemUtils.setCapacity(itemStack, (Integer)ph.getDataStorage().getData("counter"));
        }
    }

    public void turnFlashLightOn(final PlayerHealth ph, final Player player, final ItemStack flashLight, final boolean isMainHand) {
        ph.startUsingItem();
        ph.setActionState(ActionStates.USED_ELECTRIC_ITEM);
        final int[] count = new int[]{0, ItemUtils.getCapacity(flashLight)};
        final Block[] lastBlock = new Block[]{player.getLocation().getBlock().getRelative(BlockFace.UP)};
        new BukkitRunnable(){

            public void run() {
                ItemStack item = isMainHand ? player.getInventory().getItemInMainHand() : player.getInventory().getItemInOffHand();
                if (!(player.isOnline() && item != null && item.hasItemMeta() && item.getItemMeta().hasCustomModelData() && item.getItemMeta().getCustomModelData() == Flashlight.this.getNBTTag().intValue() && ItemUtils.getCapacity(item) > 0)) {
                    ItemUtils.setCapacity(flashLight, count[1]);
                    ph.resetActionState();
                    lastBlock[0].setType(Material.AIR);
                    this.cancel();
                    ph.stopUsingItem();
                    return;
                }
                if (count[0] % 60 == 0) {
                    count[1] = count[1] - 1;
                    ph.getDataStorage().setData("counter", count[1]);
                    if (count[1] <= 0) {
                        ItemUtils.setCapacity(flashLight, count[1]);
                        lastBlock[0].setType(Material.AIR);
                        ph.stopUsingItem();
                        ph.resetActionState();
                        this.cancel();
                        return;
                    }
                }
                count[0] = count[0] + 1;
                Block block = player.getLocation().getBlock().getRelative(BlockFace.UP);
                if (block.getType() == Material.AIR) {
                    boolean same;
                    boolean bl = same = block.getX() == lastBlock[0].getX() && block.getY() == lastBlock[0].getY() && block.getZ() == lastBlock[0].getZ();
                    if (same && lastBlock[0].getType().equals((Object)Material.AIR)) {
                        lastBlock[0].setType(Material.LIGHT);
                    } else if (!same && lastBlock[0].getType().equals((Object)Material.LIGHT)) {
                        final Block before = lastBlock[0];
                        new BukkitRunnable(){

                            public void run() {
                                before.setType(Material.AIR);
                            }
                        }.runTaskLater((Plugin)ZombiEraCore.instance, 3L);
                        lastBlock[0] = block;
                    } else {
                        lastBlock[0] = block;
                    }
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 1L);
    }
}

