/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.builtIn.eletric;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.ItemElectricalBase;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsableItemBase;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class Taser
extends UsableItemBase
implements ItemElectricalBase {
    public static Integer powerConsumeOnShoot = 20;

    public Taser() {
        super("Taser", (Integer)2300019, true);
    }

    @Override
    public boolean doesNeedBattery() {
        return true;
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.CREEPER_BANNER_PATTERN);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.rarity), this.getName()));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Usable & Electrical");
        lore.add(String.valueOf(ChatColor.WHITE) + "Capacity: (-1)");
        lore.add("");
        lore.add(String.valueOf(ChatColor.WHITE) + "Can be used to paralyze zombies/players");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Usage:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Left click: take battery out.");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right click: shoot");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Note:");
        lore.add(String.valueOf(ChatColor.WHITE) + "-1 -> No battery in.");
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(this.getNBTTag());
        item.setItemMeta(itemMeta);
        return item;
    }

    @Override
    public void playerItemUseByEvent(PlayerInteractEvent event) {
        final Player player = event.getPlayer();
        ItemStack taser = player.getInventory().getItemInMainHand();
        int capacity = ItemUtils.getCapacity(taser);
        boolean fireLocked = ZombiEraCore.ZEPlayerManagers.getGunsManager().fireLocked.contains(player);
        if (event.getAction().isRightClick() && !fireLocked && capacity > powerConsumeOnShoot) {
            Entity entity2;
            ZombiEraCore.ZEPlayerManagers.getGunsManager().fireLocked.add(player);
            new BukkitRunnable(){

                public void run() {
                    ZombiEraCore.ZEPlayerManagers.getGunsManager().fireLocked.remove(player);
                }
            }.runTaskLater((Plugin)ZombiEraCore.instance, 40L);
            RayTraceResult res = player.getWorld().rayTraceEntities(player.getEyeLocation().add(player.getLocation().getDirection()), player.getEyeLocation().getDirection(), 9.0, entity -> !entity.getUniqueId().equals(player.getUniqueId()));
            if (res != null && (entity2 = res.getHitEntity()) != null && entity2 instanceof LivingEntity) {
                final LivingEntity livingEntity = (LivingEntity)entity2;
                if (!(entity2 instanceof ArmorStand) && !(entity2 instanceof IronGolem)) {
                    livingEntity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 100, 5));
                    livingEntity.addPotionEffect(new PotionEffect(PotionEffectType.DARKNESS, 100, 5));
                    livingEntity.damage(1.0);
                    final int[] count = new int[]{0};
                    new BukkitRunnable(){

                        public void run() {
                            if (count[0] == 10) {
                                this.cancel();
                            }
                            Location location = livingEntity.getLocation();
                            location.add((double)(MiscUtils.globalRandom.nextFloat() * (float)MiscUtils.randomNegativePositiveInt().intValue()), 0.25 + (double)MiscUtils.globalRandom.nextFloat() * 1.75, (double)(MiscUtils.globalRandom.nextFloat() * (float)MiscUtils.randomNegativePositiveInt().intValue()));
                            livingEntity.getWorld().spawnParticle(Particle.FIREWORKS_SPARK, location, 3, 0.025, 0.025, 0.025, 0.025);
                            ZombiEraCore.getSoundManager().playSound(location, "being_tased");
                            count[0] = count[0] + 1;
                        }
                    }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 10L);
                }
            }
            Vector direction = player.getLocation().getDirection().normalize();
            direction = direction.multiply(2);
            direction.setY(direction.getY() + 1.45);
            Location pos = player.getLocation().add(direction);
            player.getWorld().spawnParticle(Particle.FIREWORKS_SPARK, pos, 10, 0.025, 0.025, 0.025, 0.025);
            ZombiEraCore.getSoundManager().playSound(player.getLocation(), "taser_fire");
            ItemUtils.setCapacity(taser, capacity - powerConsumeOnShoot);
        } else if (event.getAction().isLeftClick()) {
            this.takeOutBattery(player, taser);
        } else if (!fireLocked) {
            ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Needs charged battery! (" + powerConsumeOnShoot + "+)", 5);
        }
    }
}

