/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.builtIn.misc;

import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsableItemBase;
import zombieworldproject.zombieracore.managers.player.states.PlayerHealth;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;

public class Blueprint
extends UsableItemBase {
    String recipeName;
    String bpName;
    Map<Character, String> itemIngredients;
    String row1;
    String row2;
    String row3;

    public Blueprint(String recipeName, String bpName, String row1, String row2, String row3, Map<Character, String> itemIngredients) {
        super(bpName, (Integer)2300020, String.format("bp_%s", recipeName));
        this.recipeName = recipeName;
        this.dirName = String.format("bp_%s", recipeName);
        this.bpName = bpName;
        this.itemIngredients = itemIngredients;
        this.row1 = row1;
        this.row2 = row2;
        this.row3 = row3;
    }

    @Override
    public String getName() {
        return this.bpName;
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.CREEPER_BANNER_PATTERN);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.rarity), this.getName()));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Learnable");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Item:");
        lore.add(String.valueOf(ChatColor.WHITE) + this.recipeName);
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Recipe:");
        lore.add(String.valueOf(ChatColor.WHITE) + this.row1.replace("None", ""));
        lore.add(String.valueOf(ChatColor.WHITE) + this.row2.replace("None", ""));
        lore.add(String.valueOf(ChatColor.WHITE) + this.row3.replace("None", ""));
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Ingredients:");
        this.itemIngredients.forEach((key, value) -> lore.add(String.valueOf(ChatColor.AQUA) + key.toString() + ": " + String.valueOf(ChatColor.WHITE) + value));
        lore.add(" ");
        lore.add(String.valueOf(ChatColor.GRAY) + "Usage:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right click to learn.");
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(this.getNBTTag());
        item.setItemMeta(itemMeta);
        return item;
    }

    @Override
    public void playerItemUseByEvent(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        final PlayerHealth ph = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
        if (event.getAction().isRightClick() && !ph.isUsingItem().booleanValue()) {
            ph.startUsingItem();
            String finalBpName = "None";
            String locRecipeName = "None";
            ItemStack bpItem = player.getInventory().getItemInMainHand();
            ItemMeta meta = bpItem.getItemMeta();
            List lore = meta.getLore();
            for (int i = 0; i < lore.size(); ++i) {
                if (!((String)lore.get(i)).contains("Item:")) continue;
                locRecipeName = finalBpName = ChatColor.stripColor((String)((String)lore.get(i + 1)).trim());
                break;
            }
            if (finalBpName.equals("None")) {
                ZombiEraCore.playerInfo(player, "Invalid blueprint item!");
                return;
            }
            if (!ph.doesKnowBlueprint(finalBpName = String.format("bp_%s", finalBpName))) {
                ZombiEraCore.ZEPlayerManagers.getHealthManager().addBlueprint(player, finalBpName);
                ZombiEraCore.playerInfo(player, String.format("You have just learned %s%s%s blueprint!", ChatColor.GREEN, locRecipeName, ChatColor.WHITE));
                player.getInventory().setItemInMainHand(null);
            } else {
                ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.AQUA) + "You have already learned this blueprint!");
            }
            new BukkitRunnable(){

                public void run() {
                    ph.stopUsingItem();
                }
            }.runTaskLater((Plugin)ZombiEraCore.instance, 5L);
        }
    }
}

