/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.builtIn.misc;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsableItemBase;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;

public class Lighter
extends UsableItemBase {
    public static Integer LighterMaxCapacity = 10;
    public static Integer NBTTag = 2300016;

    public Lighter() {
        super("Lighter", NBTTag, true);
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.CREEPER_BANNER_PATTERN);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.rarity), this.getName()));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Usable");
        lore.add(String.valueOf(ChatColor.WHITE) + "Capacity: (" + LighterMaxCapacity.toString() + ")");
        lore.add(String.valueOf(ChatColor.WHITE) + "Max: <" + LighterMaxCapacity + ">");
        lore.add("");
        lore.add(String.valueOf(ChatColor.WHITE) + "Hold OFF hand to light!");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Usage:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Left click air: Refill");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right click block: Set fire");
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(this.getNBTTag());
        item.setItemMeta(itemMeta);
        return item;
    }

    @Override
    public void playerItemUseByEvent(PlayerInteractEvent event) {
        if (event.getAction() == Action.LEFT_CLICK_AIR) {
            ItemStack lighter = event.getPlayer().getInventory().getItemInMainHand();
            ItemUtils.refillGasItem(event.getPlayer(), lighter, LighterMaxCapacity);
        } else if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            ItemStack item = event.getPlayer().getInventory().getItemInMainHand();
            int capacityNow = ItemUtils.getCapacity(item);
            if (capacityNow > 0) {
                Block bup = event.getClickedBlock().getRelative(BlockFace.UP);
                if (bup.getType() == Material.AIR) {
                    bup.setType(Material.FIRE);
                    ItemUtils.setCapacity(item, capacityNow - 1);
                }
            } else {
                ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(event.getPlayer().getName(), "Lighter empty!", 5);
            }
        }
    }
}

