/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.builtIn.repairkits;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.ItemBase;
import zombieworldproject.zombieracore.managers.item.bases.ItemInsertSlot;
import zombieworldproject.zombieracore.managers.item.bases.gun.ArmedGunItemBase;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsableItemBase;
import zombieworldproject.zombieracore.managers.player.states.PlayerHealth;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class RepairGunKit
extends UsableItemBase
implements ItemInsertSlot {
    public RepairGunKit() {
        super("Repair Kit Gun", (Integer)2300027, true);
    }

    @Override
    public ItemStack getItem() {
        if (this.thisItem == null) {
            this.thisItem = this.createItem();
        }
        return this.thisItem;
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.CREEPER_BANNER_PATTERN);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.rarity), this.getName()));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Usable | Utils");
        lore.add("");
        lore.add(String.valueOf(ChatColor.WHITE) + "Can be used to repair guns.");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Usage:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right click in main hand to select which");
        lore.add(String.valueOf(ChatColor.YELLOW) + "item you want to repair.");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Note:");
        lore.add(String.valueOf(ChatColor.WHITE) + "Item must be in the hot bar! In any of the slots from 1-9.");
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(this.getNBTTag());
        item.setItemMeta(itemMeta);
        return item;
    }

    @Override
    public void playerItemUseByEvent(PlayerInteractEvent event) {
        if (event.getAction().isRightClick()) {
            final Player player = event.getPlayer();
            final PlayerHealth ph = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
            if (ph == null || ph.isInserting().booleanValue()) {
                ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Other action is in progress!", 5);
                return;
            }
            final PlayerInventory playerInventory = player.getInventory();
            HashMap<Integer, ItemStack> possibleSlots = new HashMap<Integer, ItemStack>();
            for (int i = 0; i < 9; ++i) {
                ItemStack slotItem = playerInventory.getItem(i);
                if (slotItem == null || !slotItem.hasItemMeta() || !slotItem.getItemMeta().hasCustomModelData()) continue;
                int id = slotItem.getItemMeta().getCustomModelData();
                ItemBase base = ZombiEraCore.getItemManager().getItemBase(id);
                if (!(base instanceof ArmedGunItemBase)) continue;
                possibleSlots.put(i, slotItem);
            }
            if (possibleSlots.size() == 0) {
                ZombiEraCore.playerInfo(player, "No gun in your hotbar!");
                return;
            }
            ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Choosing", 5);
            ph.startInserting();
            Object message = String.format("\n-------------------------------------\n\n%sAction%s: [%s%s%s]\n", ChatColor.AQUA, ChatColor.WHITE, ChatColor.GREEN, "Repairing gun.", ChatColor.WHITE);
            message = (String)message + "Un-equip repair kit to cancel!\nGun items:\n";
            for (Map.Entry entry : possibleSlots.entrySet()) {
                message = (String)message + String.format("> Slot: %s, item: %s\n" + String.valueOf(ChatColor.WHITE), (Integer)entry.getKey() + 1, ((ItemStack)entry.getValue()).getItemMeta().getDisplayName());
            }
            message = (String)message + "-------------------------------------";
            message = (String)message + String.valueOf(ChatColor.GOLD) + "\nWrite a number of slot" + String.valueOf(ChatColor.WHITE) + ":\n";
            ZombiEraCore.playerInfo(player, (String)message);
            new BukkitRunnable(){

                public void run() {
                    ItemStack item = playerInventory.getItemInMainHand();
                    if (!ph.isInserting().booleanValue()) {
                        this.cancel();
                    } else if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasCustomModelData() || item.getItemMeta().getCustomModelData() != RepairGunKit.this.getNBTTag().intValue()) {
                        ph.stopInserting();
                        ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Canceled", 5);
                        ZombiEraCore.playerInfo(player, "Action cancelled");
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 1L);
        }
    }

    @Override
    public void insertItem(Player player, ItemStack slotItem) {
        PlayerInventory inventory = player.getInventory();
        int idSlotItem = slotItem.getItemMeta().getCustomModelData();
        ItemBase base = ZombiEraCore.getItemManager().getItemBase(idSlotItem);
        if (base instanceof ArmedGunItemBase) {
            ArmedGunItemBase armedGunItemBase = (ArmedGunItemBase)base;
            inventory.setItemInMainHand(null);
            int maxDur = armedGunItemBase.maxDurability;
            int curDur = ItemUtils.getDurability(slotItem);
            int randomAdd = MiscUtils.generateBetweenNumbers(armedGunItemBase.maxDurability / 2, armedGunItemBase.maxDurability);
            int totalDur = Math.min(curDur + randomAdd, maxDur);
            ItemUtils.setDurability(slotItem, totalDur);
            ZombiEraCore.playerInfo(player, "The gun has been repaired.");
            ZombiEraCore.getSoundManager().playSound(player, "repair_finish");
        }
    }
}

