/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.builtIn.throwable;

import java.util.List;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.ItemLightable;
import zombieworldproject.zombieracore.managers.item.bases.ThrowableItemBase;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;

public class Dynamite
extends ThrowableItemBase
implements ItemLightable {
    public Dynamite() {
        super("Dynamite", 6640003);
    }

    @Override
    public void onCollisionHandle(final Location location) {
        Location asLoc = location.clone().add(0.0, -1.8, 0.0);
        final ArmorStand armorStand = (ArmorStand)location.getWorld().spawn(asLoc, ArmorStand.class, as -> {
            as.setInvisible(true);
            as.setGravity(false);
            as.setMarker(true);
            as.setItem(EquipmentSlot.HEAD, this.getItem());
        });
        location.add(0.0, 1.0, 0.0);
        new BukkitRunnable(){

            public void run() {
                location.createExplosion(3.0f, false, false);
                location.createExplosion(0.5f, false, false);
                location.createExplosion(0.5f, false, false);
                armorStand.remove();
            }
        }.runTaskLater((Plugin)ZombiEraCore.instance, 40L);
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.EGG);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.rarity), this.getName()));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Throwable");
        lore.add(String.valueOf(ChatColor.WHITE) + "Explodes on an impact");
        lore.add(String.valueOf(ChatColor.WHITE) + "Stronger than a grenade.");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Usage:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right click to throw.");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Note:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Requires filled lighter in off hand.");
        if (!this.stackable.booleanValue()) {
            lore.add("\u00a7" + String.valueOf(new Random().nextDouble()).replace(".", "$"));
        }
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(this.getNBTTag());
        item.setItemMeta(itemMeta);
        return item;
    }

    @Override
    public void playerItemUseByEvent(PlayerInteractEvent event) {
        Player p = event.getPlayer();
        ItemStack offHandItem = p.getInventory().getItemInOffHand();
        if (offHandItem.hasItemMeta() && offHandItem.getItemMeta().hasCustomModelData() && offHandItem.getItemMeta().getCustomModelData() == ZombiEraCore.getItemManager().usableItems.get("lighter").getItem().getItemMeta().getCustomModelData()) {
            this.useLighterWithThrowable(event, offHandItem);
        } else {
            event.setCancelled(true);
            ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(p.getName(), "Use lighter in off hand!", 5);
        }
    }
}

