/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.builtIn.throwable;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Creature;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.ItemLightable;
import zombieworldproject.zombieracore.managers.item.bases.ThrowableItemBase;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class FireCrackers
extends ThrowableItemBase
implements ItemLightable {
    public static List<String> firecrackerSounds = new ArrayList<String>(){
        {
            this.add("firecracker_1");
            this.add("firecracker_2");
        }
    };
    public static Double FireCrackerParticleOffset = 3.0;
    public static Double FireCrackerNoiseDistance = 40.0;

    public FireCrackers() {
        super("Fire Crackers", 6640008);
    }

    @Override
    public void onCollisionHandle(final Location location) {
        final int[] count = new int[]{0};
        final World world = location.getWorld();
        final Villager villager = (Villager)world.spawnEntity(location, EntityType.VILLAGER);
        villager.setInvisible(true);
        villager.setAI(false);
        villager.setInvulnerable(true);
        Location asLoc = location.clone().add(0.0, -1.8, 0.0);
        final ArmorStand armorStand = (ArmorStand)location.getWorld().spawn(asLoc, ArmorStand.class, as -> {
            as.setInvisible(true);
            as.setGravity(false);
            as.setMarker(true);
            as.setItem(EquipmentSlot.HEAD, this.getItem());
        });
        new BukkitRunnable(){

            public void run() {
                count[0] = count[0] + 1;
                ZombiEraCore.getSoundManager().playSound(location, firecrackerSounds.get(MiscUtils.globalRandom.nextInt(firecrackerSounds.size())), FireCrackerNoiseDistance);
                if (count[0] % 2 == 0) {
                    for (int i = 0; i < 1 + MiscUtils.globalRandom.nextInt(5); ++i) {
                        Location loc = location.clone();
                        loc.add((double)MiscUtils.globalRandom.nextFloat() * FireCrackerParticleOffset * (double)MiscUtils.randomNegativePositiveInt().intValue(), 0.25 + (double)(MiscUtils.globalRandom.nextFloat() * 2.0f), (double)MiscUtils.globalRandom.nextFloat() * FireCrackerParticleOffset * (double)MiscUtils.randomNegativePositiveInt().intValue());
                        world.spawnParticle(Particle.FIREWORKS_SPARK, loc, 20, 0.0, 0.0, 0.0, 0.0);
                    }
                    world.spawnParticle(Particle.FLAME, location, 4, 0.1, 0.1, 0.1, 0.1);
                }
                if (count[0] % 10 == 0) {
                    List entities = villager.getNearbyEntities(FireCrackerNoiseDistance.doubleValue(), FireCrackerNoiseDistance.doubleValue(), FireCrackerNoiseDistance.doubleValue());
                    entities.forEach(entity -> {
                        if (entity instanceof Creature) {
                            Creature creature = (Creature)entity;
                            creature.setTarget((LivingEntity)villager);
                        }
                    });
                }
                if (count[0] > 70) {
                    villager.remove();
                    armorStand.remove();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 1L, 3L);
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.EGG);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.rarity), this.getName()));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Throwable");
        lore.add(String.valueOf(ChatColor.WHITE) + "Makes loud noise for short period of time.");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Usage:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right click to throw.");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Note:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Requires filled lighter in off hand.");
        if (!this.stackable.booleanValue()) {
            lore.add("\u00a7" + String.valueOf(new Random().nextDouble()).replace(".", "$"));
        }
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(this.getNBTTag());
        item.setItemMeta(itemMeta);
        return item;
    }

    @Override
    public void playerItemUseByEvent(PlayerInteractEvent event) {
        Player p = event.getPlayer();
        ItemStack offHandItem = p.getInventory().getItemInOffHand();
        if (offHandItem.hasItemMeta() && offHandItem.getItemMeta().hasCustomModelData() && offHandItem.getItemMeta().getCustomModelData() == ZombiEraCore.getItemManager().usableItems.get("lighter").getItem().getItemMeta().getCustomModelData()) {
            this.useLighterWithThrowable(event, offHandItem);
        } else {
            event.setCancelled(true);
            ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(p.getName(), "Use lighter in off hand!", 5);
        }
    }
}

