/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.builtIn.throwable;

import java.util.List;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.handlers.PlayerHandler;
import zombieworldproject.zombieracore.managers.item.bases.ThrowableItemBase;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;

public class FlashBang
extends ThrowableItemBase {
    public FlashBang() {
        super("Flashbang", 6640005);
    }

    @Override
    public void onCollisionHandle(Location location) {
        List entities = (List)location.getNearbyEntities(15.0, 10.0, 15.0);
        for (Entity e : entities) {
            if (!(e instanceof Player)) continue;
            ((Player)e).addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 60, 1));
        }
        location.getWorld().playSound(location, Sound.ENTITY_BEE_STING, 1.0f, 2.0f);
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.EGG);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.rarity), this.getName()));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Throwable");
        lore.add(String.valueOf(ChatColor.WHITE) + "Blinds everyone who's close enough.");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Usage:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right click to throw.");
        if (!this.stackable.booleanValue()) {
            lore.add("\u00a7" + String.valueOf(new Random().nextDouble()).replace(".", "$"));
        }
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(this.getNBTTag());
        item.setItemMeta(itemMeta);
        return item;
    }

    @Override
    public void playerItemUseByEvent(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack its = player.getInventory().getItemInMainHand();
        PlayerHandler.playerEggThrows.put(event.getPlayer(), its);
    }
}

