/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.builtIn.throwable;

import java.util.List;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.handlers.PlayerHandler;
import zombieworldproject.zombieracore.managers.item.bases.ThrowableItemBase;
import zombieworldproject.zombieracore.managers.player.states.HealthStates;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class InfectionBomb
extends ThrowableItemBase {
    public InfectionBomb() {
        super("Infection Bomb", 6640004);
    }

    @Override
    public void playerItemUseByEvent(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack its = player.getInventory().getItemInMainHand();
        PlayerHandler.playerEggThrows.put(event.getPlayer(), its);
    }

    @Override
    public void onCollisionHandle(final Location location) {
        final Random rand = new Random();
        final World world = location.getWorld();
        final int[] count = new int[]{0};
        Location asLoc = location.clone().add(0.0, -1.8, 0.0);
        final ArmorStand armorStand = (ArmorStand)location.getWorld().spawn(asLoc, ArmorStand.class, as -> {
            as.setInvisible(true);
            as.setGravity(false);
            as.setMarker(true);
            as.setItem(EquipmentSlot.HEAD, this.getItem());
        });
        new BukkitRunnable(){

            public void run() {
                for (int i = 0; i < 10; ++i) {
                    Location loc = location.clone();
                    loc.add((double)(rand.nextInt(3) * MiscUtils.randomNegativePositiveInt()), 0.5, (double)(rand.nextInt(3) * MiscUtils.randomNegativePositiveInt()));
                    Particle.DustTransition dustTransition = new Particle.DustTransition(Color.fromRGB((int)0, (int)255, (int)0), Color.fromRGB((int)144, (int)238, (int)144), 1.0f);
                    world.spawnParticle(Particle.DUST_COLOR_TRANSITION, loc, 30, (Object)dustTransition);
                    loc.add(0.0, 0.5, 0.0);
                    world.spawnParticle(Particle.DUST_COLOR_TRANSITION, loc, 30, (Object)dustTransition);
                    loc.add(0.0, 0.5, 0.0);
                    world.spawnParticle(Particle.DUST_COLOR_TRANSITION, loc, 30, (Object)dustTransition);
                }
                count[0] = count[0] + 1;
                List entities = (List)world.getNearbyEntities(location, 3.0, 1.0, 3.0);
                for (Entity e : entities) {
                    if (!(e instanceof Player)) continue;
                    Player player = (Player)e;
                    ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player).setInfection(HealthStates.INFECTION, true);
                }
                world.playSound(location, Sound.ENTITY_CREEPER_HURT, 1.0f, 0.0f);
                if (count[0] >= 8) {
                    this.cancel();
                    armorStand.remove();
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 1L, 20L);
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.EGG);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.rarity), this.getName()));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Throwable");
        lore.add(String.valueOf(ChatColor.WHITE) + "Releases spores that can infect players!");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Usage:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right click to throw.");
        if (!this.stackable.booleanValue()) {
            lore.add("\u00a7" + String.valueOf(new Random().nextDouble()).replace(".", "$"));
        }
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(this.getNBTTag());
        item.setItemMeta(itemMeta);
        return item;
    }
}

