/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.builtIn.throwable;

import java.util.List;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.ItemLightable;
import zombieworldproject.zombieracore.managers.item.bases.ThrowableItemBase;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class Molotov
extends ThrowableItemBase
implements ItemLightable {
    public Molotov() {
        super("Molotov", 6640002);
    }

    @Override
    public void onCollisionHandle(Location location) {
        location.add(0.0, 1.0, 0.0);
        World world = location.getWorld();
        int offset = 3;
        block0: for (int i = 0; i < 5 + MiscUtils.globalRandom.nextInt(3); ++i) {
            Location newLoc = location.clone();
            newLoc.add((double)(MiscUtils.globalRandom.nextInt(offset) * MiscUtils.randomNegativePositiveInt()), 0.0, (double)(MiscUtils.globalRandom.nextInt(offset) * MiscUtils.randomNegativePositiveInt()));
            Block block = newLoc.getBlock();
            for (int height = 1; height < 5; ++height) {
                if (block.getType() == Material.AIR && block.getRelative(BlockFace.DOWN).isSolid()) {
                    block.setType(Material.FIRE);
                    continue block0;
                }
                block = block.getRelative(BlockFace.DOWN);
            }
        }
        world.playSound(location, Sound.BLOCK_GLASS_BREAK, 1.0f, 1.0f);
        world.spawnParticle(Particle.FLAME, location, 30, (double)0.001f, (double)0.05f, (double)0.001f);
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.EGG);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.rarity), this.getName()));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Throwable");
        lore.add(String.valueOf(ChatColor.WHITE) + "Needs to be set on fire.");
        lore.add(String.valueOf(ChatColor.WHITE) + "Fire in the hole!");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Usage:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right click to throw.");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Note:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Requires filled lighter in off hand.");
        if (!this.stackable.booleanValue()) {
            lore.add("\u00a7" + String.valueOf(new Random().nextDouble()).replace(".", "$"));
        }
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(this.getNBTTag());
        item.setItemMeta(itemMeta);
        return item;
    }

    @Override
    public void playerItemUseByEvent(PlayerInteractEvent event) {
        Player p = event.getPlayer();
        ItemStack offHandItem = p.getInventory().getItemInOffHand();
        if (offHandItem.hasItemMeta() && offHandItem.getItemMeta().hasCustomModelData() && offHandItem.getItemMeta().getCustomModelData() == ZombiEraCore.getItemManager().usableItems.get("lighter").getItem().getItemMeta().getCustomModelData()) {
            this.useLighterWithThrowable(event, offHandItem);
        } else {
            event.setCancelled(true);
            ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(p.getName(), "Use lighter in off hand!", 5);
        }
    }
}

