/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.builtIn.throwable;

import java.util.List;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.ItemLightable;
import zombieworldproject.zombieracore.managers.item.bases.ThrowableItemBase;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;

public class PipeBomb
extends ThrowableItemBase
implements ItemLightable {
    public PipeBomb() {
        super("Pipe Bomb", 6640007);
    }

    @Override
    public void onCollisionHandle(Location location) {
        location.createExplosion(2.0f, false, false);
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.EGG);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.rarity), this.getName()));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Throwable");
        lore.add(String.valueOf(ChatColor.WHITE) + "Needs to be set on fire.");
        lore.add(String.valueOf(ChatColor.WHITE) + "Explodes immediately on impact.");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Usage:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right click to throw.");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Note:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Requires filled lighter in off hand.");
        if (!this.stackable.booleanValue()) {
            lore.add("\u00a7" + String.valueOf(new Random().nextDouble()).replace(".", "$"));
        }
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(this.getNBTTag());
        item.setItemMeta(itemMeta);
        return item;
    }

    @Override
    public void playerItemUseByEvent(PlayerInteractEvent event) {
        Player p = event.getPlayer();
        ItemStack offHandItem = p.getInventory().getItemInOffHand();
        if (offHandItem.hasItemMeta() && offHandItem.getItemMeta().hasCustomModelData() && offHandItem.getItemMeta().getCustomModelData() == ZombiEraCore.getItemManager().usableItems.get("lighter").getItem().getItemMeta().getCustomModelData()) {
            this.useLighterWithThrowable(event, offHandItem);
        } else {
            event.setCancelled(true);
            ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(p.getName(), "Use lighter in off hand!", 5);
        }
    }
}

