/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.builtIn.throwable;

import java.util.List;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.handlers.PlayerHandler;
import zombieworldproject.zombieracore.managers.item.bases.ThrowableItemBase;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;

public class SmokeGrenade
extends ThrowableItemBase {
    public SmokeGrenade() {
        super("Smoke Grenade", 6640006);
    }

    @Override
    public void onCollisionHandle(final Location location) {
        final World world = location.getWorld();
        final int[] count = new int[]{0};
        Location asLoc = location.clone().add(0.0, -1.8, 0.0);
        final ArmorStand armorStand = (ArmorStand)location.getWorld().spawn(asLoc, ArmorStand.class, as -> {
            as.setInvisible(true);
            as.setGravity(false);
            as.setMarker(true);
            as.setItem(EquipmentSlot.HEAD, this.getItem());
        });
        location.add(0.0, 0.5, 0.0);
        new BukkitRunnable(){

            public void run() {
                for (double phi = 0.0; phi <= Math.PI; phi += 0.6283185307179586) {
                    for (double theta = 0.0; theta <= Math.PI * 2; theta += 0.3141592653589793) {
                        double r = 1.5;
                        double x = r * Math.cos(theta) * Math.sin(phi);
                        double y = r * Math.cos(phi) + 1.5;
                        double z = r * Math.sin(theta) * Math.sin(phi);
                        location.add(x, y, z);
                        location.getWorld().spawnParticle(Particle.SMOKE_LARGE, location, 2, 0.1, 0.1, 0.1, 0.1);
                        location.subtract(x, y, z);
                    }
                }
                world.playSound(location, Sound.BLOCK_SAND_BREAK, 1.0f, 0.25f);
                if (count[0] > 40) {
                    this.cancel();
                    armorStand.remove();
                }
                count[0] = count[0] + 1;
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 10L);
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.EGG);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.rarity), this.getName()));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Throwable");
        lore.add(String.valueOf(ChatColor.WHITE) + "Releases lot of smoke.");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Usage:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right click to throw.");
        if (!this.stackable.booleanValue()) {
            lore.add("\u00a7" + String.valueOf(new Random().nextDouble()).replace(".", "$"));
        }
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(this.getNBTTag());
        item.setItemMeta(itemMeta);
        return item;
    }

    @Override
    public void playerItemUseByEvent(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack its = player.getInventory().getItemInMainHand();
        PlayerHandler.playerEggThrows.put(event.getPlayer(), its);
    }
}

