/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.stats;

import java.util.List;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.stats.BonusStats;
import zombieworldproject.zombieracore.managers.item.stats.StatType;
import zombieworldproject.zombieracore.managers.item.stats.types.MinMaxStat;
import zombieworldproject.zombieracore.misc.other.ItemRarity;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;

public final class ZEBonusStats {
    public static final String bonusLine = "Adjustment";

    public static BonusStats getBonusStatsForConfigItem(FileConfiguration config, String itemConfigPath) {
        BonusStats bonusStats = new BonusStats();
        for (StatType type : StatType.values()) {
            String value = config.getString(itemConfigPath + ".bonus." + type.toString().toLowerCase());
            if (value == null) continue;
            switch (type) {
                case DAMAGE: {
                    double minDamage = config.getDouble(itemConfigPath + ".bonus.damage.min");
                    double maxDamage = config.getDouble(itemConfigPath + ".bonus.damage.max");
                    bonusStats.addDamageStat(new MinMaxStat(minDamage, maxDamage));
                    ZombiEraCore.debugInfo("Added damage bonus stats to item: " + itemConfigPath);
                    break;
                }
            }
            ZombiEraCore.debugInfo("Added bonus stats to item: " + itemConfigPath);
        }
        return bonusStats;
    }

    public static void editEntityDamageByEntityEvent(EntityDamageByEntityEvent event, ItemStack itemStack) {
        String damage = ZEBonusStats.getBonusValue(itemStack, StatType.DAMAGE);
        ZombiEraCore.debugInfo("Damage bonus: " + damage);
        if (damage != null) {
            event.setDamage(event.getDamage() + Double.parseDouble(damage));
        }
    }

    public static String getBonusValue(ItemStack itemStack, StatType value) {
        if (itemStack == null || !itemStack.hasItemMeta()) {
            return null;
        }
        return ItemUtils.getValueFromLore(itemStack, value.toString(), bonusLine);
    }

    public static void setBonusStats(ItemStack itemStack, BonusStats bonusStats, String originalName) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return;
        }
        List lore = meta.getLore();
        if (lore == null) {
            return;
        }
        MinMaxStat statsDamage = bonusStats.getDamage();
        ZEBonusStats.deleteAllBonuses(lore, bonusLine);
        lore.add(String.valueOf(ChatColor.AQUA) + "Adjustment:");
        if (statsDamage != null) {
            double damage = statsDamage.getRandomStat();
            if (damage < 0.0) {
                lore.add(String.valueOf(ChatColor.RED) + "Damage: <" + damage + ">");
            } else {
                lore.add(String.valueOf(ChatColor.GREEN) + "Damage: <" + damage + ">");
            }
            String prefix = ItemRarity.preNameFor(damage, statsDamage.getMinStat(), statsDamage.getMaxStat());
            meta.setDisplayName(String.format("%s %s| %s", originalName, ChatColor.WHITE, prefix));
        }
        meta.setLore(lore);
        itemStack.setItemMeta(meta);
    }

    public static void deleteAllBonuses(List<String> lore, String value) {
        for (int i = 0; i < lore.size(); ++i) {
            if (!lore.get(i).contains(value)) continue;
            lore.subList(i, lore.size()).clear();
            return;
        }
    }
}

