/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.stats.types;

import java.util.Random;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class MinMaxStat {
    double minStat;
    double maxStat;

    public MinMaxStat(double minStat, double maxStat) {
        this.minStat = minStat;
        this.maxStat = maxStat;
    }

    public static void main(String[] args) {
        MinMaxStat minMaxStat = new MinMaxStat(-4.0, 5.0);
        double sum = 0.0;
        double lowest = Double.MAX_VALUE;
        double highest = Double.MIN_VALUE;
        int lowestPosition = 0;
        int highestPosition = 0;
        int attempts = 1000000;
        for (int i = 0; i < attempts; ++i) {
            double randomStat = minMaxStat.getRandomStat();
            System.out.println("Random value " + (i + 1) + ": " + randomStat);
            sum += randomStat;
            if (randomStat < lowest) {
                lowest = randomStat;
                lowestPosition = i + 1;
            }
            if (!(randomStat > highest)) continue;
            highest = randomStat;
            highestPosition = i + 1;
        }
        double average = sum / (double)attempts;
        System.out.println("Average: " + average);
        System.out.println("Lowest value: " + lowest + " at position " + lowestPosition);
        System.out.println("Highest value: " + highest + " at position " + highestPosition);
    }

    public double getMinStat() {
        return this.minStat;
    }

    public double getMaxStat() {
        return this.maxStat;
    }

    public double getRandomStat() {
        Random random = new Random();
        double exponent = 2.0;
        double randomFactor = random.nextDouble();
        double randomValue = Math.pow(randomFactor, exponent);
        randomValue = this.minStat + randomValue * (this.maxStat - this.minStat);
        return MiscUtils.round(randomValue, 3);
    }
}

