/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.loot;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.inventory.ItemStack;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.ZERarityDropManager;

public class LootCrate {
    public World world;
    public Integer x;
    public Integer y;
    public Integer z;
    public ZERarityDropManager.RarityGroup rarityGroup;
    private LocalDateTime nextGeneratedDate;
    private Boolean runningReset = false;

    public LootCrate(World world, Integer x, Integer y, Integer z, ZERarityDropManager.RarityGroup rarityGroup) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.nextGeneratedDate = LocalDateTime.now();
        this.rarityGroup = rarityGroup;
    }

    public long getSecondsUntilRespawn() {
        long duration = Duration.between(LocalDateTime.now(), this.nextGeneratedDate).getSeconds();
        if (duration < 0L) {
            return 0L;
        }
        return duration;
    }

    public void resetTimer() {
        if (this.runningReset.booleanValue()) {
            return;
        }
        Block chest = this.world.getBlockAt(this.x.intValue(), this.y.intValue(), this.z.intValue());
        if (chest.getType() != Material.CHEST) {
            ZombiEraCore.getLootManager().removeCrate(this);
            return;
        }
        Chest chestLoot = (Chest)chest.getState();
        if (chestLoot.getBlockInventory().isEmpty()) {
            this.nextGeneratedDate = LocalDateTime.now().plusSeconds(this.rarityGroup.crateRespawnLootSeconds.intValue());
            this.runningReset = true;
        }
    }

    public void generateLoot(boolean force) {
        LocalDateTime lastGeneratedDate = LocalDateTime.now();
        Block chest = this.world.getBlockAt(this.x.intValue(), this.y.intValue(), this.z.intValue());
        if (chest.getType() != Material.CHEST) {
            ZombiEraCore.getLootManager().removeCrate(this);
            return;
        }
        Chest chestLoot = (Chest)chest.getState();
        if (force) {
            chestLoot.getBlockInventory().clear();
        }
        if (!lastGeneratedDate.isAfter(this.nextGeneratedDate) && !force) {
            return;
        }
        if (chestLoot.getBlockInventory().isEmpty()) {
            List<ItemStack> items = this.rarityGroup.generateItemStacks();
            items.forEach(item -> chestLoot.getBlockInventory().addItem(new ItemStack[]{item}));
            this.runningReset = false;
            this.nextGeneratedDate = LocalDateTime.now().plusSeconds(this.rarityGroup.crateRespawnLootSeconds.intValue());
        }
    }
}

