/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.loot;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.player.PlayerInteractEvent;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.ZERarityDropManager;
import zombieworldproject.zombieracore.managers.loot.LootCrate;

public class ZELootCrateManager {
    private static final String CONFIG_FILE_PATH = "/data/crates.yml";
    private static final String CRATES_SECTION = "crates";
    private static final String POSITION_FORMAT = "%s_%s_%s";
    private static final String COORDINATE_DELIMITER = "_";
    public Map<String, LootCrate> lootCrates = new HashMap<String, LootCrate>();
    private File configFile;

    public void addLootCrate(World world, Integer x, Integer y, Integer z, String groupName) {
        if (!this.isValidRarityGroup(groupName)) {
            return;
        }
        LootCrate lootCrate = this.createLootCrate(world, x, y, z, groupName);
        this.lootCrates.put(this.getPositionKey(x, y, z), lootCrate);
        lootCrate.generateLoot(true);
        this.saveLootCrateToConfig(world, x, y, z, groupName);
    }

    public void addLootCrateNoSave(World world, Integer x, Integer y, Integer z, String groupName) {
        if (!this.isValidRarityGroup(groupName)) {
            return;
        }
        LootCrate lootCrate = this.createLootCrate(world, x, y, z, groupName);
        this.lootCrates.put(this.getPositionKey(x, y, z), lootCrate);
        lootCrate.generateLoot(true);
    }

    public void removeCrate(LootCrate crate) {
        this.lootCrates.remove(this.getPositionKey(crate.x, crate.y, crate.z));
    }

    public boolean removeCrate(Integer x, Integer y, Integer z) {
        LootCrate crate = this.getCrate(x, y, z);
        if (crate == null) {
            return false;
        }
        this.removeCrate(crate);
        this.deleteLootCrateFromConfig(x, y, z);
        return true;
    }

    public LootCrate getCrate(Integer x, Integer y, Integer z) {
        return this.lootCrates.get(this.getPositionKey(x, y, z));
    }

    public void loadDataFromFile(World world) {
        this.initializeConfigFile();
        if (!this.configFile.exists()) {
            this.createEmptyConfigFile();
            return;
        }
        this.loadCratesFromConfig(world);
    }

    public void interactWithChestEvent(PlayerInteractEvent event) {
        Block chestBlock = event.getClickedBlock();
        if (chestBlock == null) {
            return;
        }
        String positionKey = this.getPositionKey(chestBlock.getX(), chestBlock.getY(), chestBlock.getZ());
        LootCrate crate = this.lootCrates.get(positionKey);
        if (crate != null) {
            crate.generateLoot(false);
        }
    }

    public String getPos(Integer x, Integer y, Integer z) {
        return this.getPositionKey(x, y, z);
    }

    private void initializeConfigFile() {
        this.configFile = new File(ZombiEraCore.instance.getDataFolder(), CONFIG_FILE_PATH);
    }

    private void createEmptyConfigFile() {
        try {
            this.configFile.getParentFile().mkdirs();
            this.configFile.createNewFile();
            YamlConfiguration config = new YamlConfiguration();
            config.save(this.configFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create loot crates configuration file", e);
        }
    }

    private void loadCratesFromConfig(World world) {
        YamlConfiguration config = this.loadConfig();
        ConfigurationSection cratesSection = config.getConfigurationSection(CRATES_SECTION);
        if (cratesSection == null) {
            return;
        }
        for (String key : cratesSection.getKeys(false)) {
            if (!this.isForWorld(config, key, world)) continue;
            this.loadSingleCrate(config, key, world);
        }
    }

    private boolean isForWorld(YamlConfiguration config, String key, World world) {
        String configWorld = config.getString(this.buildConfigPath(key, "world"));
        return world.getName().equals(configWorld);
    }

    private void loadSingleCrate(YamlConfiguration config, String key, World world) {
        String groupName = config.getString(this.buildConfigPath(key, "group"));
        if (groupName == null) {
            return;
        }
        Coordinates coords = this.parseCoordinates(key);
        if (coords != null) {
            this.addLootCrateNoSave(world, coords.x, coords.y, coords.z, groupName);
        }
    }

    private Coordinates parseCoordinates(String key) {
        try {
            String[] parts = key.split(COORDINATE_DELIMITER);
            if (parts.length != 3) {
                return null;
            }
            return new Coordinates(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void saveLootCrateToConfig(World world, Integer x, Integer y, Integer z, String groupName) {
        YamlConfiguration config = this.loadConfig();
        String positionKey = this.getPositionKey(x, y, z);
        config.set(this.buildConfigPath(positionKey, "group"), (Object)groupName);
        config.set(this.buildConfigPath(positionKey, "world"), (Object)world.getName());
        this.saveConfig(config);
    }

    private void deleteLootCrateFromConfig(Integer x, Integer y, Integer z) {
        YamlConfiguration config = this.loadConfig();
        String positionKey = this.getPositionKey(x, y, z);
        config.set(this.buildConfigPath(positionKey, null), null);
        this.saveConfig(config);
    }

    private LootCrate createLootCrate(World world, Integer x, Integer y, Integer z, String groupName) {
        ZERarityDropManager.RarityGroup rarityGroup = ZombiEraCore.getRarityDropManager().groupRarities.get(groupName);
        return new LootCrate(world, x, y, z, rarityGroup);
    }

    private boolean isValidRarityGroup(String groupName) {
        return ZombiEraCore.getRarityDropManager().groupRarities.containsKey(groupName);
    }

    private String getPositionKey(Integer x, Integer y, Integer z) {
        return String.format(POSITION_FORMAT, x, y, z);
    }

    private String buildConfigPath(String key, String property) {
        if (property == null) {
            return String.format("%s.%s", CRATES_SECTION, key);
        }
        return String.format("%s.%s.%s", CRATES_SECTION, key, property);
    }

    private YamlConfiguration loadConfig() {
        return YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    private void saveConfig(YamlConfiguration config) {
        try {
            config.save(this.configFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save loot crates configuration", e);
        }
    }

    private static class Coordinates {
        final int x;
        final int y;
        final int z;

        Coordinates(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

