/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.npc;

import java.util.Collection;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.EntityEquipment;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.npc.NPCHandler;
import zombieworldproject.zombieracore.managers.npc.NPCTypes;

public class NPCBase {
    private final String inventoryTitle;
    public String idName;
    public String displayName;
    public NPCHandler npcHandler;
    public NPCTypes type;
    public Villager villager;
    public Location location;
    public HashMap<String, String> equipment = new HashMap();
    public Villager.Profession profession;

    public NPCBase(String idName, String displayName, NPCTypes type, NPCHandler npcHandler, Location location, Villager.Profession profession) {
        this.idName = idName;
        this.type = type;
        this.npcHandler = npcHandler;
        this.location = location;
        this.displayName = displayName;
        this.inventoryTitle = ZombiEraCore.getNPCManager().getNewId(this);
        this.profession = profession;
    }

    public String getInventoryTitle() {
        return this.inventoryTitle;
    }

    public Villager getVillager() {
        return this.villager;
    }

    public Integer getEntityID() {
        return this.villager.getEntityId();
    }

    public boolean spawn() {
        if (this.villager != null && !this.villager.isDead()) {
            return false;
        }
        Collection entities = this.location.getNearbyEntities(1.0, 1.0, 1.0);
        entities.forEach(entity -> {
            if (entity.getType().equals((Object)EntityType.VILLAGER)) {
                entity.remove();
            }
        });
        this.villager = (Villager)this.location.getWorld().spawnEntity(this.location, EntityType.VILLAGER, CreatureSpawnEvent.SpawnReason.CUSTOM);
        this.villager.setProfession(this.profession);
        this.villager.setAI(false);
        this.villager.setInvulnerable(true);
        this.villager.setCustomNameVisible(true);
        this.villager.setCustomName(this.displayName);
        ZombiEraCore.getNPCManager().registerSelf(this);
        return true;
    }

    public void setEquipment() {
        if (this.villager != null && !this.villager.isDead()) {
            EntityEquipment equipmentE = this.villager.getEquipment();
            if (this.equipment.containsKey("head")) {
                equipmentE.setHelmet(ZombiEraCore.getItemManager().getItemBase(this.equipment.get("head")).getItem());
            }
            if (this.equipment.containsKey("chest")) {
                equipmentE.setChestplate(ZombiEraCore.getItemManager().getItemBase(this.equipment.get("chest")).getItem());
            }
            if (this.equipment.containsKey("leggings")) {
                equipmentE.setLeggings(ZombiEraCore.getItemManager().getItemBase(this.equipment.get("leggings")).getItem());
            }
            if (this.equipment.containsKey("boots")) {
                equipmentE.setBoots(ZombiEraCore.getItemManager().getItemBase(this.equipment.get("boots")).getItem());
            }
        }
    }

    public boolean deSpawn() {
        if (this.villager != null && !this.villager.isDead()) {
            ZombiEraCore.getNPCManager().unregisterSelf(this);
            this.villager.remove();
            return true;
        }
        return false;
    }

    public boolean deSpawn(boolean register) {
        if (this.villager != null && !this.villager.isDead()) {
            if (register) {
                ZombiEraCore.getNPCManager().unregisterSelf(this);
            }
            this.villager.remove();
            return true;
        }
        return false;
    }

    public NPCTypes getNPCType() {
        return this.type;
    }

    public NPCHandler getNpcHandler() {
        return this.npcHandler;
    }
}

