/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.npc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Villager;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.util.Vector;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.npc.NPCBase;
import zombieworldproject.zombieracore.managers.npc.NPCHandler;
import zombieworldproject.zombieracore.managers.npc.NPCTrader;
import zombieworldproject.zombieracore.managers.npc.NPCTypes;
import zombieworldproject.zombieracore.managers.npc.config.NPCTraderConfig;
import zombieworldproject.zombieracore.managers.npc.handlers.AuctionHandler;
import zombieworldproject.zombieracore.managers.npc.handlers.TraderHandler;

public class ZENPCManager {
    public Map<Integer, NPCBase> npcList = new HashMap<Integer, NPCBase>();
    public Map<NPCTypes, NPCHandler> npcHandlers = new HashMap<NPCTypes, NPCHandler>();
    public Map<String, NPCBase> inventoryTitles = new HashMap<String, NPCBase>();
    public Map<String, NPCTraderConfig> npcTraderConfigMap = new HashMap<String, NPCTraderConfig>();
    private File npcConfig;
    private Integer count = 0;

    public String getNewId(NPCBase npc) {
        Integer n = this.count;
        this.count = this.count + 1;
        String id = String.format("NPC%s", this.count);
        this.inventoryTitles.put(id, npc);
        return id;
    }

    public NPCBase getNPCByLocation(Location location) {
        if (location == null) {
            return null;
        }
        for (NPCBase npc : this.npcList.values()) {
            if (!npc.location.equals((Object)location)) continue;
            return npc;
        }
        return null;
    }

    public List<String> getIdNamesOfNPCs() {
        ArrayList<String> names = new ArrayList<String>();
        this.npcList.values().forEach(npc -> {
            if (!names.contains(npc.idName)) {
                names.add(npc.idName);
            }
        });
        return names;
    }

    public void reloadNPCConfigs() {
        YamlConfiguration config;
        ConfigurationSection configSection;
        NPCTraderConfig defaultConfig = new NPCTraderConfig("default");
        this.npcTraderConfigMap.put("default", defaultConfig);
        this.npcConfig = new File(ZombiEraCore.instance.getDataFolder(), "npcs.yml");
        if (!this.npcConfig.exists()) {
            try {
                this.npcConfig.createNewFile();
            }
            catch (IOException e) {
                ZombiEraCore.instance.getLogger().severe("Failed to create npcs.yml: " + e.getMessage());
            }
        }
        if ((configSection = (config = YamlConfiguration.loadConfiguration((File)this.npcConfig)).getConfigurationSection("npcs.config.trader")) == null) {
            return;
        }
        for (String key1 : configSection.getKeys(false)) {
            ConfigurationSection itemsSection = config.getConfigurationSection(String.format("npcs.config.trader.%s.items", key1));
            NPCTraderConfig cfg = new NPCTraderConfig(key1);
            this.npcTraderConfigMap.put(key1, cfg);
            if (itemsSection == null) continue;
            for (String key2 : itemsSection.getKeys(false)) {
                Double buyPrice = config.getDouble(String.format("npcs.config.trader.%s.items.%s.price.buy", key1, key2));
                Double sellPrice = config.getDouble(String.format("npcs.config.trader.%s.items.%s.price.sell", key1, key2));
                Integer slot = config.getInt(String.format("npcs.config.trader.%s.items.%s.slot", key1, key2));
                cfg.addConfiguredItem(key2, buyPrice, sellPrice, slot);
            }
        }
    }

    public boolean removeNPC(String idName) {
        Iterator<Map.Entry<Integer, NPCBase>> it = this.npcList.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, NPCBase> entry = it.next();
            NPCBase npc = entry.getValue();
            if (!npc.idName.equals(idName)) continue;
            this.inventoryTitles.remove(npc.getInventoryTitle());
            npc.deSpawn();
            it.remove();
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.npcConfig);
            config.set(String.format("npcs.entity.%s", idName), null);
            try {
                config.save(this.npcConfig);
            }
            catch (IOException e) {
                ZombiEraCore.instance.getLogger().severe("Failed to save after NPC removal: " + e.getMessage());
            }
            return true;
        }
        return false;
    }

    public NPCBase createAuction(Location location, String displayName, String idName, Villager.Profession profession) {
        NPCTypes type = NPCTypes.AUCTION;
        NPCBase auction = new NPCBase(idName, displayName, type, this.npcHandlers.get((Object)NPCTypes.AUCTION), location, profession);
        this.saveNPCToConfig(location, displayName, idName, type, profession, null);
        auction.spawn();
        return auction;
    }

    public NPCBase createTrader(Location location, String displayName, String idName, String npcConfigName, Villager.Profession profession) {
        NPCTraderConfig npcConfigInv = this.npcTraderConfigMap.get(npcConfigName);
        if (npcConfigInv == null) {
            throw new IllegalStateException("NPC config not found: " + npcConfigName);
        }
        NPCTypes type = NPCTypes.TRADER;
        NPCTrader trader = new NPCTrader(idName, displayName, type, this.npcHandlers.get((Object)NPCTypes.TRADER), location, npcConfigInv, profession);
        this.saveNPCToConfig(location, displayName, idName, type, profession, npcConfigName);
        trader.spawn();
        return trader;
    }

    private void saveNPCToConfig(Location loc, String displayName, String idName, NPCTypes type, Villager.Profession profession, String npcConfigName) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.npcConfig);
        config.set(String.format("npcs.entity.%s.displayName", idName), (Object)displayName);
        config.set(String.format("npcs.entity.%s.type", idName), (Object)type.toString());
        config.set(String.format("npcs.entity.%s.profession", idName), (Object)profession.toString());
        if (npcConfigName != null) {
            config.set(String.format("npcs.entity.%s.config", idName), (Object)npcConfigName);
        }
        config.set(String.format("npcs.entity.%s.x", idName), (Object)loc.getX());
        config.set(String.format("npcs.entity.%s.y", idName), (Object)loc.getY());
        config.set(String.format("npcs.entity.%s.z", idName), (Object)loc.getZ());
        Vector direction = loc.getDirection();
        config.set(String.format("npcs.entity.%s.dirX", idName), (Object)direction.getX());
        config.set(String.format("npcs.entity.%s.dirY", idName), (Object)direction.getY());
        config.set(String.format("npcs.entity.%s.dirZ", idName), (Object)direction.getZ());
        config.set(String.format("npcs.entity.%s.yaw", idName), (Object)Float.valueOf(loc.getYaw()));
        config.set(String.format("npcs.entity.%s.pitch", idName), (Object)Float.valueOf(loc.getPitch()));
        config.set(String.format("npcs.entity.%s.world", idName), (Object)Objects.requireNonNull(loc.getWorld()).getName());
        try {
            config.save(this.npcConfig);
        }
        catch (IOException e) {
            ZombiEraCore.instance.getLogger().severe("Failed to save NPC config: " + e.getMessage());
        }
    }

    public void reloadNPCs(World world) {
        this.npcConfig = new File(ZombiEraCore.instance.getDataFolder(), "npcs.yml");
        ZombiEraCore.debugInfo("Loading NPCs for world: " + world.getName());
        if (!this.npcConfig.exists()) {
            try {
                this.npcConfig.createNewFile();
            }
            catch (IOException e) {
                ZombiEraCore.instance.getLogger().severe("Failed to create npcs.yml: " + e.getMessage());
            }
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.npcConfig);
        ConfigurationSection section = config.getConfigurationSection("npcs.entity");
        if (section == null) {
            return;
        }
        for (String idName : section.getKeys(false)) {
            String worldName = config.getString(String.format("npcs.entity.%s.world", idName));
            if (!world.getName().equals(worldName)) continue;
            try {
                String[] slots;
                String displayName = config.getString(String.format("npcs.entity.%s.displayName", idName));
                NPCTypes type = NPCTypes.valueOf(config.getString(String.format("npcs.entity.%s.type", idName)).toUpperCase());
                double x = config.getDouble(String.format("npcs.entity.%s.x", idName));
                double y = config.getDouble(String.format("npcs.entity.%s.y", idName));
                double z = config.getDouble(String.format("npcs.entity.%s.z", idName));
                double dirX = config.getDouble(String.format("npcs.entity.%s.dirX", idName));
                double dirY = config.getDouble(String.format("npcs.entity.%s.dirY", idName));
                double dirZ = config.getDouble(String.format("npcs.entity.%s.dirZ", idName));
                float yaw = (float)config.getDouble(String.format("npcs.entity.%s.yaw", idName));
                float pitch = (float)config.getDouble(String.format("npcs.entity.%s.pitch", idName));
                Location location = new Location(world, x, y, z);
                location.setDirection(new Vector(dirX, dirY, dirZ));
                location.setYaw(yaw);
                location.setPitch(pitch);
                Villager.Profession profession = Villager.Profession.valueOf((String)config.getString(String.format("npcs.entity.%s.profession", idName)).toUpperCase());
                NPCBase npc = null;
                switch (type) {
                    case TRADER: {
                        String configName = config.getString(String.format("npcs.entity.%s.config", idName));
                        npc = new NPCTrader(idName, displayName, type, this.npcHandlers.get((Object)NPCTypes.TRADER), location, this.npcTraderConfigMap.get(configName), profession);
                        break;
                    }
                    case AUCTION: {
                        npc = new NPCBase(idName, displayName, type, this.npcHandlers.get((Object)NPCTypes.AUCTION), location, profession);
                    }
                }
                if (npc == null) continue;
                for (String slot : slots = new String[]{"head", "chest", "leggings", "boots"}) {
                    String key = String.format("npcs.entity.%s.equipment.%s", idName, slot);
                    if (!config.isSet(key)) continue;
                    npc.equipment.put(slot, config.getString(key));
                }
                npc.setEquipment();
                npc.spawn();
            }
            catch (Exception e) {
                ZombiEraCore.instance.getLogger().severe("Failed to load NPC: " + idName + " - " + e.getMessage());
            }
        }
        ZombiEraCore.debugInfo("NPC loading finished for world: " + world.getName());
    }

    public void onClickInventory(InventoryClickEvent event, String title) {
        NPCBase npc = this.inventoryTitles.get(title);
        if (npc != null) {
            npc.getNpcHandler().inventoryClick(event, npc);
        }
    }

    public void registerSelf(NPCBase npc) {
        this.npcList.put(npc.getEntityID(), npc);
    }

    public void unregisterSelf(NPCBase npc) {
        this.npcList.remove(npc.getEntityID());
    }

    public void disablePlugin() {
        this.npcList.values().forEach(npc -> npc.deSpawn(false));
        this.npcList.clear();
    }

    public void loadHandlers() {
        this.npcHandlers.put(NPCTypes.AUCTION, new AuctionHandler());
        this.npcHandlers.put(NPCTypes.TRADER, new TraderHandler());
    }

    public void initialize() {
        this.loadHandlers();
        this.reloadNPCConfigs();
    }

    public void reload() {
        this.disablePlugin();
        this.reloadNPCConfigs();
        for (World world : Bukkit.getWorlds()) {
            this.reloadNPCs(world);
        }
        this.count = 0;
        this.npcTraderConfigMap.clear();
        this.inventoryTitles.clear();
    }
}

