/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.npc.handlers;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import zombieworldproject.zombieracore.managers.npc.NPCBase;
import zombieworldproject.zombieracore.managers.npc.NPCHandler;
import zombieworldproject.zombieracore.managers.npc.gui.GUIElement;
import zombieworldproject.zombieracore.managers.npc.gui.GUIHelper;

public class AuctionHandler
implements NPCHandler {
    public static void confirm(Inventory inventory) {
    }

    public static void pageNext(Inventory inventory) {
    }

    public static void pagePrevious(Inventory inventory) {
    }

    public static void loadPage(Inventory inventory) {
        ItemStack[] items = new ItemStack[36];
        AuctionHandler.setPage(items, inventory);
    }

    public static void setPage(ItemStack[] items, Inventory inventory) {
        for (int i = 9; i < 45; ++i) {
            if (items[i - 9] == null) {
                inventory.setItem(i, AuctionHandler.getEmptySlotItem());
                continue;
            }
            inventory.setItem(i, items[i]);
        }
    }

    public static void setCommonElements(Inventory inventory, int currentPage) {
        inventory.setItem(52, AuctionHandler.getMenuItem());
        inventory.setItem(53, AuctionHandler.getPageNextItem(currentPage));
        inventory.setItem(45, AuctionHandler.getPreviousPageItem(currentPage));
        AuctionHandler.fillEmptySlots(inventory);
    }

    public static void fillEmptySlots(Inventory inventory) {
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (inventory.getItem(i) != null) continue;
            inventory.setItem(i, AuctionHandler.getEmptySlotItem());
        }
    }

    public static void browse(Inventory inventory) {
        inventory.clear();
        inventory.setItem(0, AuctionHandler.getBrowseItem());
        AuctionHandler.setCommonElements(inventory, 0);
    }

    public static void sell(Inventory inventory) {
        inventory.clear();
        inventory.setItem(0, AuctionHandler.getSellItem());
        AuctionHandler.fillEmptySlots(inventory);
        inventory.setItem(22, null);
        inventory.setItem(52, AuctionHandler.getMenuItem());
        inventory.setItem(53, AuctionHandler.getConfirmItem());
    }

    public static void mySold(Inventory inventory) {
        inventory.clear();
        inventory.setItem(0, AuctionHandler.getMySoldItem());
        AuctionHandler.setCommonElements(inventory, 0);
    }

    public static Inventory createGUIMenu(String title) {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)title);
        inv.setItem(21, AuctionHandler.getBrowseItem());
        inv.setItem(22, AuctionHandler.getSellItem());
        inv.setItem(23, AuctionHandler.getMySoldItem());
        AuctionHandler.fillEmptySlots(inv);
        return inv;
    }

    public static ItemStack getEmptySlotItem() {
        return new ItemStack(Material.GLASS_PANE){
            {
                ItemMeta meta = this.getItemMeta();
                meta.setDisplayName(" ");
                this.setItemMeta(meta);
            }
        };
    }

    public static ItemStack getPageNextItem(final int currentPage) {
        return new ItemStack(Material.ARROW){
            {
                super(type);
                ItemMeta meta = this.getItemMeta();
                meta.setDisplayName("Next Page");
                ArrayList<CallSite> lore = new ArrayList<CallSite>();
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.WHITE) + "Current Page: " + currentPage)));
                meta.setLore(lore);
                this.setItemMeta(meta);
            }
        };
    }

    public static ItemStack getPreviousPageItem(final int currentPage) {
        return new ItemStack(Material.ARROW){
            {
                super(type);
                ItemMeta meta = this.getItemMeta();
                meta.setDisplayName("Previous Page");
                ArrayList<CallSite> lore = new ArrayList<CallSite>();
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.WHITE) + "Current Page: " + currentPage)));
                meta.setLore(lore);
                this.setItemMeta(meta);
            }
        };
    }

    public static ItemStack getMySoldItem() {
        return new ItemStack(Material.GRAY_STAINED_GLASS_PANE){
            {
                ItemMeta meta = this.getItemMeta();
                meta.setDisplayName("My Sold");
                this.setItemMeta(meta);
            }
        };
    }

    public static ItemStack getSellItem() {
        return new ItemStack(Material.YELLOW_STAINED_GLASS_PANE){
            {
                ItemMeta meta = this.getItemMeta();
                meta.setDisplayName("Sell");
                this.setItemMeta(meta);
            }
        };
    }

    public static ItemStack getBrowseItem() {
        return new ItemStack(Material.GRAY_STAINED_GLASS_PANE){
            {
                ItemMeta meta = this.getItemMeta();
                meta.setDisplayName("Browse");
                this.setItemMeta(meta);
            }
        };
    }

    public static ItemStack getMenuItem() {
        return new ItemStack(Material.RED_STAINED_GLASS_PANE){
            {
                ItemMeta meta = this.getItemMeta();
                meta.setDisplayName("Menu");
                this.setItemMeta(meta);
            }
        };
    }

    public static ItemStack getConfirmItem() {
        return new ItemStack(Material.GREEN_STAINED_GLASS_PANE){
            {
                ItemMeta meta = this.getItemMeta();
                meta.setDisplayName("Confirm");
                this.setItemMeta(meta);
            }
        };
    }

    @Override
    public void openInventory(Player player, NPCBase npc) {
        Inventory menu = AuctionHandler.createGUIMenu(npc.getInventoryTitle());
        player.openInventory(menu);
    }

    @Override
    public void inventoryClick(InventoryClickEvent event, NPCBase npc) {
        event.setCancelled(true);
        ItemStack currentItem = event.getCurrentItem();
        if (event.getClickedInventory() == null) {
            return;
        }
        if (currentItem == null) {
            return;
        }
        GUIElement element = GUIHelper.getGUIElement(currentItem);
        if (element == null) {
            return;
        }
        switch (element) {
            case BROWSE: {
                AuctionHandler.browse(event.getClickedInventory());
                AuctionHandler.loadPage(event.getClickedInventory());
                break;
            }
            case SELL: {
                AuctionHandler.sell(event.getClickedInventory());
                break;
            }
            case MY_SOLD: {
                AuctionHandler.mySold(event.getClickedInventory());
                break;
            }
            case MENU: {
                event.getClickedInventory().setContents(AuctionHandler.createGUIMenu(npc.getInventoryTitle()).getContents());
                break;
            }
            case PAGE_NEXT: {
                AuctionHandler.pageNext(event.getClickedInventory());
                break;
            }
            case PAGE_PREV: {
                AuctionHandler.pagePrevious(event.getClickedInventory());
                break;
            }
            case CONFIRM: {
                AuctionHandler.confirm(event.getClickedInventory());
            }
        }
    }
}

