/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.npc.handlers;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.npc.NPCBase;
import zombieworldproject.zombieracore.managers.npc.NPCHandler;
import zombieworldproject.zombieracore.managers.npc.NPCTrader;
import zombieworldproject.zombieracore.managers.npc.config.NPCConfiguredItem;
import zombieworldproject.zombieracore.managers.player.states.PlayerHealth;

public class TraderHandler
implements NPCHandler {
    @Override
    public void openInventory(Player player, NPCBase npc) {
        Inventory inventory = Bukkit.createInventory(null, (int)54, (String)npc.getInventoryTitle());
        NPCTrader npcTrader = (NPCTrader)npc;
        List<NPCConfiguredItem> items = npcTrader.getNpcTraderConfig().getAllItems();
        for (int i = 0; i < items.size(); ++i) {
            NPCConfiguredItem configuredItem = items.get(i);
            inventory.setItem(configuredItem.getSlot().intValue(), configuredItem.getItem().clone());
        }
        player.openInventory(inventory);
    }

    public void sellItem(Integer nbtId, Double sellPrice, Player player) {
        PlayerInventory playerInv = player.getInventory();
        for (int i = 0; i < 54; ++i) {
            int id;
            ItemStack item = playerInv.getItem(i);
            if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasCustomModelData() || (id = item.getItemMeta().getCustomModelData()) != nbtId) continue;
            if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
                playerInv.setItem(i, item);
            } else {
                playerInv.setItem(i, null);
            }
            PlayerHealth ph = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
            ph.setBalance(ph.getBalance() + sellPrice);
            ZombiEraCore.playerInfo(player, String.format("Added $ %s%s%s to your balance!", ChatColor.GREEN, sellPrice, ChatColor.WHITE));
            return;
        }
    }

    public void buyItem(Integer nbtId, Double buyPrice, Player player) {
        PlayerHealth ph = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
        if (ph.getBalance() < buyPrice) {
            ZombiEraCore.playerInfo(player, "You don't have enough balance for this!");
        } else if (player.getInventory().firstEmpty() != -1) {
            ItemStack item = ZombiEraCore.getItemManager().getItemBase(nbtId).getItem();
            player.getInventory().addItem(new ItemStack[]{item});
            ph.setBalance(ph.getBalance() - buyPrice);
            ZombiEraCore.playerInfo(player, String.format("You bought %s%s%s for $ %s%s%s.", ChatColor.AQUA, item.getItemMeta().getDisplayName(), ChatColor.WHITE, ChatColor.GREEN, buyPrice, ChatColor.WHITE));
        } else {
            ZombiEraCore.playerInfo(player, "You need atleast one free slot in your inventory!");
        }
    }

    public Double getPrice(String filter, ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (int i = 0; i < lore.size(); ++i) {
            String line = (String)lore.get(i);
            if (!line.contains(filter)) continue;
            return Double.parseDouble(line.substring(line.indexOf("<") + 1, line.indexOf(">")));
        }
        return null;
    }

    @Override
    public void inventoryClick(InventoryClickEvent event, NPCBase npc) {
        event.setCancelled(true);
        int slot = event.getSlot();
        ItemStack item = event.getInventory().getItem(slot);
        if (item == null) {
            return;
        }
        if (event.isLeftClick()) {
            Double sellPrice = this.getPrice("Sell", item);
            if (sellPrice == null) {
                return;
            }
            this.sellItem(item.getItemMeta().getCustomModelData(), sellPrice, (Player)event.getWhoClicked());
        } else if (event.isRightClick()) {
            Double buyPrice = this.getPrice("Buy", item);
            if (buyPrice == null) {
                return;
            }
            this.buyItem(item.getItemMeta().getCustomModelData(), buyPrice, (Player)event.getWhoClicked());
        }
    }
}

