/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.player;

import java.text.DecimalFormat;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.player.states.PlayerHealth;

public final class ZEScoreBoardManager {
    private static Team hiddenNameTeam = null;

    private ZEScoreBoardManager() {
    }

    public static void Initialize() {
        hiddenNameTeam = ZEScoreBoardManager.createHiddenNameTeam();
    }

    public static void setScoreBoardPlayer(Player player) {
        if (player == null) {
            return;
        }
        player.setScoreboard(ZEScoreBoardManager.createScoreBoardPlayer(player));
    }

    public static void addPlayerToHiddenNameTeam(Player player) {
        if (player == null) {
            return;
        }
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Team team = scoreboard.getTeam("hiddenNameTeam");
        if (team == null) {
            team = ZEScoreBoardManager.createHiddenNameTeam();
        }
        team.addEntry(player.getName());
    }

    private static Team createHiddenNameTeam() {
        Scoreboard mainScoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Team team = mainScoreboard.getTeam("hiddenNameTeam");
        if (team == null) {
            team = mainScoreboard.registerNewTeam("hiddenNameTeam");
            team.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
        }
        return team;
    }

    private static Scoreboard createScoreBoardPlayer(Player player) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
        Objective objective = scoreboard.registerNewObjective("scoreboard", "dummy");
        objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        PlayerHealth playerHealth = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
        DecimalFormat decimalFormat = new DecimalFormat("#.###");
        double balance = playerHealth.getBalance();
        objective.setDisplayName(String.format("%s$ %s", ChatColor.GREEN, decimalFormat.format(balance)));
        int lineIndex = 1;
        ZEScoreBoardManager.addSeparator(objective, lineIndex++);
        String zoneInfo = String.valueOf(ChatColor.GOLD) + "Zone: " + String.valueOf(ChatColor.WHITE) + ZombiEraCore.getZoneManager().getZoneTypeScoreboardString(playerHealth.getPrioritizedZone());
        objective.getScore(zoneInfo).setScore(lineIndex++);
        if (ZombiEraCore.getCombatLogManager().isCombat(player).booleanValue()) {
            String combatLine = String.valueOf(ChatColor.DARK_RED) + String.format("COMBAT FLAGGED%s: %ss", ChatColor.WHITE, ZombiEraCore.getCombatLogManager().getCombatLogTime(player));
            objective.getScore(combatLine).setScore(lineIndex++);
        }
        ZEScoreBoardManager.addSeparator(objective, lineIndex++);
        List<String> states = playerHealth.createScoreBoardStatesList();
        if (states.isEmpty()) {
            objective.getScore(String.valueOf(ChatColor.GREEN) + "You are healthy").setScore(lineIndex++);
        } else {
            for (String state : states) {
                objective.getScore(state).setScore(lineIndex++);
            }
        }
        ZEScoreBoardManager.addSeparator(objective, lineIndex);
        return scoreboard;
    }

    private static void addSeparator(Objective objective, int score) {
        objective.getScore(String.valueOf(ChatColor.GRAY) + "-------------------").setScore(score);
    }
}

