/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.player.messages;

import com.google.common.base.Splitter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.ZombiEraSettings;
import zombieworldproject.zombieracore.managers.player.messages.ActionBarMessage;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class ZESpecialMessageManager {
    public final List<ActionBarMessage> abMessages = new ArrayList<ActionBarMessage>();
    public final Map<Player, List<Integer>> aboveHeadMessages = new HashMap<Player, List<Integer>>();

    public void Initialize() {
        this.updateBars();
    }

    public void addAboveHeadMessage(final Player player, final String message, final int delay) {
        final String[] messageArray = new String[]{message};
        new BukkitRunnable(){

            public void run() {
                ZESpecialMessageManager.this.aboveHeadMessages.computeIfAbsent(player, k -> new ArrayList());
                final List<Integer> messages = ZESpecialMessageManager.this.aboveHeadMessages.get(player);
                if (messages.size() > 4) {
                    return;
                }
                ArrayList<String> additionalLines = new ArrayList<String>();
                if (messageArray[0].length() > 45) {
                    int i = 0;
                    for (String part : Splitter.fixedLength((int)45).split((CharSequence)message)) {
                        if (i == 0) {
                            messageArray[0] = part;
                        } else {
                            additionalLines.add(part);
                        }
                        ++i;
                    }
                }
                final int uniqueId = messageArray[0].hashCode() + MiscUtils.globalRandom.nextInt(1000, 10000);
                messages.add(uniqueId);
                for (int i = 0; i < additionalLines.size(); ++i) {
                    ZESpecialMessageManager.this.addAboveHeadMessage(player, (String)additionalLines.get(i), delay * (i + 1));
                }
                Location location = player.getEyeLocation().add(0.0, 0.05, 0.0);
                final ArmorStand armorStand = (ArmorStand)player.getWorld().spawn(location, ArmorStand.class, as -> {
                    as.setMarker(true);
                    as.setGravity(false);
                    as.setVisible(false);
                    as.setCustomNameVisible(true);
                    as.setInvulnerable(true);
                    as.setSmall(true);
                });
                armorStand.setCustomName(messageArray[0]);
                final int[] timer = new int[]{0};
                new BukkitRunnable(){

                    public void run() {
                        if (timer[0] >= delay) {
                            messages.remove((Object)uniqueId);
                            armorStand.remove();
                            this.cancel();
                            return;
                        }
                        int index = messages.indexOf(uniqueId);
                        Location loc = player.getEyeLocation().add(0.0, 0.2 + 0.25 * (double)(4 - index), 0.0);
                        armorStand.teleport(loc);
                        timer[0] = timer[0] + 2;
                    }
                }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 2L);
            }
        }.runTask((Plugin)ZombiEraCore.instance);
    }

    public boolean addActionBarMessage(String playerName, String message, int maxTicks) {
        this.abMessages.removeIf(ab -> ab.player.equals(playerName));
        this.abMessages.add(new ActionBarMessage(playerName, message, maxTicks));
        return true;
    }

    public boolean addActionBarMessage(String playerName, String message, Integer maxTicks) {
        this.abMessages.removeIf(ab -> Objects.equals(ab.player, playerName));
        this.abMessages.add(maxTicks == null ? new ActionBarMessage(playerName, message) : new ActionBarMessage(playerName, message, maxTicks));
        return true;
    }

    public void updateBars() {
        new BukkitRunnable(){

            public void run() {
                ArrayList<ActionBarMessage> currentMessages = new ArrayList<ActionBarMessage>(ZESpecialMessageManager.this.abMessages);
                ArrayList players = new ArrayList(Bukkit.getOnlinePlayers());
                ArrayList<String> playersSent = new ArrayList<String>();
                HashMap<String, CallSite> thirstBars = new HashMap<String, CallSite>();
                for (Player p : players) {
                    int thirst = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(p).getThirstAmount();
                    String thirstBar = String.valueOf(ChatColor.BLACK) + "\u25cf".repeat(ZombiEraSettings.PLAYER_THIRST_MAX - thirst) + String.valueOf(ChatColor.BLUE) + "\u25cf".repeat(thirst) + String.valueOf(ChatColor.WHITE);
                    thirstBars.put(p.getName(), (CallSite)((Object)thirstBar));
                }
                for (ActionBarMessage ab : currentMessages) {
                    Player p = Bukkit.getPlayer((String)ab.player);
                    if (p == null || !thirstBars.containsKey(ab.player)) continue;
                    String msg = ab.doTick();
                    String thirstBar = (String)thirstBars.get(ab.player);
                    String finalMsg = msg + " ".repeat(Math.max(0, 47 - msg.length() - thirstBar.length())) + thirstBar;
                    p.sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)finalMsg));
                    playersSent.add(ab.player);
                    if (ab.ticked <= ab.ticks) continue;
                    ZESpecialMessageManager.this.abMessages.remove(ab);
                }
                for (Player p : players) {
                    String thirstBar;
                    if (playersSent.contains(p.getName()) || (thirstBar = (String)thirstBars.get(p.getName())) == null) continue;
                    p.sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)(" ".repeat(Math.max(0, 47 - thirstBar.length())) + thirstBar)));
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 1L, 5L);
    }
}

