/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.player.skills;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.player.states.PlayerStats;

public class ZESkillsManager {
    private final ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();

    public ZESkillsManager() {
        this.updateAllPlayerTabs();
    }

    public void updateTabForPlayer(Player player) {
        PlayerStats stats = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player).getPlayerStats();
        Object footer = "";
        footer = (String)footer + String.valueOf(ChatColor.UNDERLINE) + "                                          \n" + String.valueOf(ChatColor.WHITE);
        footer = (String)footer + "\n                  STATS                  \n\n";
        footer = (String)footer + "Player Kills:" + " ".repeat("Walked distance:".length() - "Player Kills:".length()) + String.format(" %s", stats.playerKills);
        footer = (String)footer + "\nZombie Kills:" + " ".repeat("Walked distance:".length() - "Zombie Kills:".length()) + String.format(" %s", stats.zombieKills);
        footer = (String)footer + "\nWalked blocks:" + String.format(" %s", stats.walkedDistance);
        footer = (String)footer + "\n";
        this.setCustomTabList(player, String.format("\n".repeat(5), ChatColor.RED, ChatColor.GREEN, ChatColor.WHITE), (String)footer);
    }

    public void updateAllPlayerTabs() {
        Bukkit.getOnlinePlayers().forEach(player -> this.updateTabForPlayer((Player)player));
    }

    public void setCustomTabList(Player player, String header, String footer) {
        PacketContainer headerPacket = this.protocolManager.createPacket(PacketType.Play.Server.PLAYER_LIST_HEADER_FOOTER);
        headerPacket.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)header));
        headerPacket.getChatComponents().write(1, (Object)WrappedChatComponent.fromText((String)footer));
        try {
            this.protocolManager.sendServerPacket(player, headerPacket);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

