/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.player.states;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.ZombiEraSettings;
import zombieworldproject.zombieracore.managers.ZEIconsManager;
import zombieworldproject.zombieracore.managers.player.ZEScoreBoardManager;
import zombieworldproject.zombieracore.managers.player.states.ActionStates;
import zombieworldproject.zombieracore.managers.player.states.DynamicDataStorage;
import zombieworldproject.zombieracore.managers.player.states.HealthStates;
import zombieworldproject.zombieracore.managers.player.states.PlayerStats;
import zombieworldproject.zombieracore.managers.player.states.ZEStateManager;
import zombieworldproject.zombieracore.managers.player.states.handlers.BleedingHandler;
import zombieworldproject.zombieracore.managers.player.states.handlers.BrokenLegHandler;
import zombieworldproject.zombieracore.managers.player.states.handlers.InfectionHandler;
import zombieworldproject.zombieracore.managers.player.states.handlers.SicknessHandler;
import zombieworldproject.zombieracore.managers.zones.ConfigZone;
import zombieworldproject.zombieracore.managers.zones.ZoneBase;
import zombieworldproject.zombieracore.managers.zones.ZoneTypes;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class PlayerHealth {
    public static final List<String> HUNGER_SOUNDS = List.of("stomach1", "stomach2", "stomach3");
    private final Player player;
    private final Map<HealthStates, Boolean> playerHealth;
    private final Map<HealthStates, Integer> playerHealthTimers = new HashMap<HealthStates, Integer>();
    private final BleedingHandler bleedingHandler;
    private final InfectionHandler infectionHandler;
    private final BrokenLegHandler brokenLegHandler;
    private final SicknessHandler sicknessHandler;
    private final DynamicDataStorage dataStorage;
    private final List<ZoneBase> zonesIn = new ArrayList<ZoneBase>();
    private final PlayerStats playerStats;
    private ConfigZone configZone;
    private Double balance = 0.0;
    private Double stamina = 100.0;
    private Integer thirstAmount = ZombiEraSettings.PLAYER_THIRST_MAX;
    public Boolean drop = false;
    private Boolean thirstDamage = false;
    private Boolean isUsingItem = false;
    private Boolean isInserting = false;
    private ActionStates lastState = ActionStates.NONE;
    public final List<String> knownBlueprints = new ArrayList<String>();

    public PlayerHealth(Player player) {
        this.player = player;
        this.playerHealth = ZombiEraCore.ZEPlayerManagers.getHealthManager().getDefaultHealthStates();
        this.bleedingHandler = new BleedingHandler(this);
        this.infectionHandler = new InfectionHandler(this);
        this.brokenLegHandler = new BrokenLegHandler(this);
        this.sicknessHandler = new SicknessHandler(this);
        this.dataStorage = new DynamicDataStorage();
        this.addTimers();
        this.playerStats = new PlayerStats(player, 0, 0);
        this.runThirstUpdates();
    }

    public PlayerStats getPlayerStats() {
        return this.playerStats;
    }

    public Double getStamina() {
        return this.stamina;
    }

    public void setStamina(Double stamina) {
        this.stamina = stamina;
    }

    public Double getBalance() {
        return this.balance;
    }

    public void setBalance(Double balance) {
        this.balance = balance;
        ZEScoreBoardManager.setScoreBoardPlayer(this.player);
    }

    public boolean doesKnowBlueprint(String bpDirName) {
        return this.knownBlueprints.contains(bpDirName);
    }

    public ConfigZone getLastConfigZone() {
        return this.configZone;
    }

    public void playerEnterZone(ZoneBase zoneBase) {
        this.zonesIn.add(zoneBase);
        if (zoneBase.hasConfigZone()) {
            this.configZone = zoneBase.getConfigZone();
        }
        this.sortZones();
    }

    public void playerLeaveZone(ZoneBase zoneBase) {
        this.zonesIn.remove(zoneBase);
        if (zoneBase.hasConfigZone()) {
            this.configZone = null;
        }
        this.sortZones();
    }

    private void sortZones() {
        this.zonesIn.sort(Comparator.comparingInt(o -> this.getZoneTypeIndex(o.getZoneType())));
    }

    private int getZoneTypeIndex(ZoneTypes zoneType) {
        return switch (zoneType) {
            default -> throw new IncompatibleClassChangeError();
            case ZoneTypes.SAFE -> 0;
            case ZoneTypes.RADIATION -> 1;
            case ZoneTypes.LIVABLE -> 2;
            case ZoneTypes.CONFIG -> 3;
            case ZoneTypes.NONE -> 4;
        };
    }

    public List<ZoneBase> getCurrentZones() {
        return this.zonesIn;
    }

    public Boolean isInfected() {
        return this.playerHealth.get((Object)HealthStates.INFECTION);
    }

    public ZoneTypes getPrioritizedZone() {
        return this.zonesIn.isEmpty() ? ZoneTypes.NONE : this.zonesIn.get(0).getZoneType();
    }

    public DynamicDataStorage getDataStorage() {
        return this.dataStorage;
    }

    public ActionStates getLastActionState() {
        return this.lastState;
    }

    public void resetActionState() {
        this.lastState = ActionStates.NONE;
    }

    public void setActionState(ActionStates state) {
        this.lastState = state;
    }

    public void startInserting() {
        this.isInserting = true;
    }

    public void stopInserting() {
        this.isInserting = false;
    }

    public Boolean isInserting() {
        return this.isInserting;
    }

    public Integer getThirstAmount() {
        return this.thirstAmount;
    }

    public void setThirstAmount(Integer thirstAmount) {
        this.thirstAmount = thirstAmount;
    }

    public boolean isInSafeZone() {
        return this.zonesIn.stream().anyMatch(z -> z.getZoneType() == ZoneTypes.SAFE);
    }

    public void addWater(Integer amount) {
        if (amount > 0) {
            this.thirstAmount = Math.min(this.thirstAmount + amount, ZombiEraSettings.PLAYER_THIRST_MAX);
        } else if (amount < 0) {
            this.thirstAmount = Math.max(this.thirstAmount + amount, 0);
        }
        if (this.thirstAmount > 0) {
            new BukkitRunnable(){

                public void run() {
                    ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(PlayerHealth.this.player.getName(), "", 5);
                }
            }.runTaskLater((Plugin)ZombiEraCore.instance, 10L);
            this.thirstDamage = false;
        }
    }

    private void runThirstUpdates() {
        new BukkitRunnable(){

            public void run() {
                if (!PlayerHealth.this.player.isOnline() || PlayerHealth.this.drop.booleanValue()) {
                    this.cancel();
                    return;
                }
                if (MiscUtils.generateChange(60.0 * (1.0 - (double)(20 - PlayerHealth.this.player.getFoodLevel()) / 20.0))) {
                    ZombiEraCore.getSoundManager().playSound(PlayerHealth.this.player.getLocation(), MiscUtils.getRandomEntry(HUNGER_SOUNDS));
                }
                if (PlayerHealth.this.thirstAmount > 0) {
                    Integer n = PlayerHealth.this.thirstAmount;
                    PlayerHealth.this.thirstAmount = PlayerHealth.this.thirstAmount - 1;
                }
                if (PlayerHealth.this.thirstAmount == 0 && !PlayerHealth.this.thirstDamage.booleanValue()) {
                    PlayerHealth.this.thirstDamage = true;
                    new BukkitRunnable(){

                        public void run() {
                            if (!PlayerHealth.this.player.isOnline()) {
                                this.cancel();
                                PlayerHealth.this.drop = true;
                                return;
                            }
                            if (PlayerHealth.this.thirstAmount <= 0 && PlayerHealth.this.thirstDamage.booleanValue()) {
                                PlayerHealth.this.player.damage(1.0);
                                if (!PlayerHealth.this.isUsingItem.booleanValue()) {
                                    ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(PlayerHealth.this.player.getName(), String.format("You are %sthirsty%s!", ChatColor.AQUA, ChatColor.WHITE), Integer.MAX_VALUE);
                                }
                            } else {
                                ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(PlayerHealth.this.player.getName(), "", 5);
                                PlayerHealth.this.thirstDamage = false;
                                this.cancel();
                            }
                        }
                    }.runTaskTimer((Plugin)ZombiEraCore.instance, 20L, (long)ZombiEraSettings.PLAYER_THIRST_DAMAGE_TICKS.intValue());
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, (long)ZombiEraSettings.PLAYER_THIRST_UPDATE_TICKS.intValue(), (long)ZombiEraSettings.PLAYER_THIRST_UPDATE_TICKS.intValue());
    }

    public Boolean isUsingItem() {
        return this.isUsingItem;
    }

    public void startUsingItem() {
        this.isUsingItem = true;
    }

    public void startUsingItem(Integer ticks) {
        this.isUsingItem = true;
        new BukkitRunnable(){

            public void run() {
                PlayerHealth.this.stopUsingItem();
            }
        }.runTaskLater((Plugin)ZombiEraCore.instance, (long)ticks.intValue());
    }

    public void stopUsingItem() {
        this.isUsingItem = false;
    }

    private void addTimers() {
        this.playerHealthTimers.clear();
        this.playerHealth.forEach((key, value) -> this.playerHealthTimers.put((HealthStates)((Object)key), 0));
    }

    public Integer timerTick(HealthStates state) {
        int tickNow = this.playerHealthTimers.get((Object)state);
        int tickNext = tickNow + 1;
        this.playerHealthTimers.put(state, tickNext);
        return tickNext;
    }

    public void resetTimer(HealthStates state) {
        this.playerHealthTimers.put(state, 0);
    }

    public List<String> createScoreBoardStatesList() {
        ZEStateManager manager = ZombiEraCore.ZEPlayerManagers.getHealthManager();
        ZEIconsManager iconManager = ZombiEraCore.getIconsManager();
        ArrayList<String> states = new ArrayList<String>();
        this.playerHealth.forEach((key, value) -> {
            if (Boolean.TRUE.equals(value)) {
                String icon = switch (key) {
                    case HealthStates.LEG_BLEEDING_RIGHT -> iconManager.getIcon("right_leg");
                    case HealthStates.LEG_BLEEDING_LEFT -> iconManager.getIcon("left_leg");
                    case HealthStates.HAND_BLEEDING_LEFT -> iconManager.getIcon("left_hand");
                    case HealthStates.HAND_BLEEDING_RIGHT -> iconManager.getIcon("right_hand");
                    case HealthStates.NECK_BLEEDING -> iconManager.getIcon("neck");
                    case HealthStates.CHEST_BLEEDING -> iconManager.getIcon("chest");
                    default -> "";
                };
                states.add((String)(icon.isEmpty() ? "" : icon + " ") + manager.getStateString((HealthStates)((Object)key)));
            }
        });
        return states;
    }

    public Map<HealthStates, Boolean> getHealth() {
        return this.playerHealth;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setState(HealthStates state, Boolean enabled) {
        if (enabled.booleanValue() && this.isInSafeZone()) {
            return;
        }
        if (state.name().contains("BLEEDING")) {
            this.setBleeding(state, enabled);
        } else if (state == HealthStates.INFECTION) {
            this.setInfection(state, enabled);
        } else if (state == HealthStates.BROKEN_LEG_LEFT || state == HealthStates.BROKEN_LEG_RIGHT) {
            this.setBrokenLeg(state, enabled);
        } else if (state == HealthStates.SICK || state == HealthStates.STOMACH_SICKNESS) {
            this.setSickness(state, enabled);
        }
    }

    public void setSickness(HealthStates state, Boolean enabled) {
        this.sicknessHandler.setState(state, enabled);
    }

    public void setRandomLegBroken() {
        if (this.isInSafeZone()) {
            return;
        }
        Collections.shuffle(BrokenLegHandler.legStates);
        HealthStates leg1 = BrokenLegHandler.legStates.get(0);
        HealthStates leg2 = BrokenLegHandler.legStates.get(1);
        if (!this.getHealth().get((Object)leg1).booleanValue()) {
            this.setBrokenLeg(leg1, true);
        } else if (!this.getHealth().get((Object)leg2).booleanValue()) {
            this.setBrokenLeg(leg2, true);
        }
    }

    public void setRandomLegBleeding() {
        Collections.shuffle(BleedingHandler.lowerBodyPartStates);
        HealthStates leg1 = BleedingHandler.lowerBodyPartStates.get(0);
        HealthStates leg2 = BleedingHandler.lowerBodyPartStates.get(1);
        if (!this.getHealth().get((Object)leg1).booleanValue()) {
            this.setBleeding(leg1, true);
        } else if (!this.getHealth().get((Object)leg2).booleanValue()) {
            this.setBleeding(leg2, true);
        }
    }

    public void setBleeding(HealthStates state, Boolean enabled) {
        if (enabled.booleanValue() && this.isInSafeZone()) {
            return;
        }
        this.bleedingHandler.setState(state, enabled);
    }

    public void setInfection(HealthStates state, Boolean enabled) {
        if (enabled.booleanValue() && this.isInSafeZone()) {
            return;
        }
        this.infectionHandler.setState(state, enabled);
    }

    public void setBrokenLeg(HealthStates state, Boolean enabled) {
        this.brokenLegHandler.setState(state, enabled);
    }
}

