/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.player.states;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.ZombiEraSettings;
import zombieworldproject.zombieracore.managers.item.bases.ItemBase;
import zombieworldproject.zombieracore.managers.item.bases.equitable.EquitableTypes;
import zombieworldproject.zombieracore.managers.item.bases.equitable.ZEEquipmentsManager;
import zombieworldproject.zombieracore.managers.item.bases.equitable.items.EquitableItemBase;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.BulletResult;
import zombieworldproject.zombieracore.managers.player.ZEScoreBoardManager;
import zombieworldproject.zombieracore.managers.player.states.HealthStates;
import zombieworldproject.zombieracore.managers.player.states.PlayerHealth;
import zombieworldproject.zombieracore.managers.player.states.PlayerStats;
import zombieworldproject.zombieracore.managers.player.states.StateSettings;
import zombieworldproject.zombieracore.managers.player.states.handlers.BleedingHandler;
import zombieworldproject.zombieracore.managers.player.states.handlers.BrokenLegHandler;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class ZEStateManager {
    private final Map<HealthStates, String> stateScoreBoardStrings = new HashMap<HealthStates, String>(){
        {
            this.put(HealthStates.NECK_BLEEDING, String.format("%sBleeding%s : Neck", ChatColor.RED, ChatColor.WHITE));
            this.put(HealthStates.CHEST_BLEEDING, String.format("%sBleeding%s : Chest", ChatColor.RED, ChatColor.WHITE));
            this.put(HealthStates.HAND_BLEEDING_LEFT, String.format("%sBleeding%s : Left hand", ChatColor.RED, ChatColor.WHITE));
            this.put(HealthStates.HAND_BLEEDING_RIGHT, String.format("%sBleeding%s : Right hand", ChatColor.RED, ChatColor.WHITE));
            this.put(HealthStates.LEG_BLEEDING_LEFT, String.format("%sBleeding%s : Left leg", ChatColor.RED, ChatColor.WHITE));
            this.put(HealthStates.LEG_BLEEDING_RIGHT, String.format("%sBleeding%s : Right leg", ChatColor.RED, ChatColor.WHITE));
            this.put(HealthStates.INFECTION, String.format("%s\u2620 %sInfected %s\u2620", ChatColor.WHITE, ChatColor.GREEN, ChatColor.WHITE));
            this.put(HealthStates.BROKEN_LEG_LEFT, String.format("%sFracture%s : Left leg", ChatColor.AQUA, ChatColor.WHITE));
            this.put(HealthStates.BROKEN_LEG_RIGHT, String.format("%sFracture%s : Right leg", ChatColor.AQUA, ChatColor.WHITE));
            this.put(HealthStates.STOMACH_SICKNESS, String.format("%sSickness%s : Stomach", ChatColor.YELLOW, ChatColor.WHITE));
            this.put(HealthStates.SICK, String.format("%sFeeling sick%s", ChatColor.YELLOW, ChatColor.WHITE));
        }
    };
    private final Map<Player, PlayerHealth> playerHealthMap = new HashMap<Player, PlayerHealth>();
    private Map<HealthStates, StateSettings> statesSettings = new HashMap<HealthStates, StateSettings>();

    public ZEStateManager() {
        this.reloadStatesSettings();
    }

    public void reloadStatesSettings() {
        this.statesSettings = new HashMap<HealthStates, StateSettings>(){
            {
                this.put(HealthStates.NECK_BLEEDING, new StateSettings(ZombiEraSettings.NECK_BLEEDING_CHANCE, ZombiEraSettings.NECK_BLEEDING_DAMAGE, ZombiEraSettings.NECK_BLEEDING_TIMER));
                this.put(HealthStates.CHEST_BLEEDING, new StateSettings(ZombiEraSettings.CHEST_BLEEDING_CHANCE, ZombiEraSettings.CHEST_BLEEDING_DAMAGE, ZombiEraSettings.CHEST_BLEEDING_TIMER));
                this.put(HealthStates.HAND_BLEEDING_LEFT, new StateSettings(ZombiEraSettings.HAND_BLEEDING_LEFT_CHANCE, ZombiEraSettings.HAND_BLEEDING_LEFT_DAMAGE, ZombiEraSettings.HAND_BLEEDING_LEFT_TIMER));
                this.put(HealthStates.HAND_BLEEDING_RIGHT, new StateSettings(ZombiEraSettings.HAND_BLEEDING_RIGHT_CHANCE, ZombiEraSettings.HAND_BLEEDING_RIGHT_DAMAGE, ZombiEraSettings.HAND_BLEEDING_RIGHT_TIMER));
                this.put(HealthStates.LEG_BLEEDING_LEFT, new StateSettings(ZombiEraSettings.LEG_BLEEDING_LEFT_CHANCE, ZombiEraSettings.LEG_BLEEDING_LEFT_DAMAGE, ZombiEraSettings.LEG_BLEEDING_LEFT_TIMER));
                this.put(HealthStates.LEG_BLEEDING_RIGHT, new StateSettings(ZombiEraSettings.LEG_BLEEDING_RIGHT_CHANCE, ZombiEraSettings.LEG_BLEEDING_RIGHT_DAMAGE, ZombiEraSettings.LEG_BLEEDING_RIGHT_TIMER));
                this.put(HealthStates.INFECTION, new StateSettings(ZombiEraSettings.INFECTION_CHANCE, ZombiEraSettings.INFECTION_DAMAGE, ZombiEraSettings.INFECTION_TIMER));
                this.put(HealthStates.BROKEN_LEG_LEFT, new StateSettings(ZombiEraSettings.BROKEN_LEG_LEFT_CHANCE, ZombiEraSettings.BROKEN_LEG_LEFT_DAMAGE, ZombiEraSettings.BROKEN_LEG_LEFT_TIMER));
                this.put(HealthStates.BROKEN_LEG_RIGHT, new StateSettings(ZombiEraSettings.BROKEN_LEG_RIGHT_CHANCE, ZombiEraSettings.BROKEN_LEG_RIGHT_DAMAGE, ZombiEraSettings.BROKEN_LEG_RIGHT_TIMER));
            }
        };
    }

    public HashMap<HealthStates, Boolean> getDefaultHealthStates() {
        return new HashMap<HealthStates, Boolean>(){
            {
                for (HealthStates s : HealthStates.values()) {
                    this.put(s, false);
                }
            }
        };
    }

    public PlayerHealth getPlayerHealth(Player player) {
        return this.playerHealthMap.get(player);
    }

    public String getStateString(HealthStates state) {
        return this.stateScoreBoardStrings.get((Object)state);
    }

    public StateSettings getStateSettings(HealthStates state) {
        return this.statesSettings.get((Object)state);
    }

    public void entityMeleeHitPlayer(Player player, Entity entity) {
        StateSettings inf;
        PlayerHealth ph = this.playerHealthMap.get(player);
        Collections.shuffle(BleedingHandler.bleedingStates);
        ZEEquipmentsManager.EquipmentInventory eqInv = ZEEquipmentsManager.playerEquipmentInventories.get(player);
        double scratchMod = eqInv != null ? eqInv.getScratchProtection() : 0.0;
        double biteMod = eqInv != null ? eqInv.getBiteProtection() : 0.0;
        HealthStates bleedState = BleedingHandler.bleedingStates.get(MiscUtils.globalRandom.nextInt(BleedingHandler.bleedingStates.size()));
        StateSettings settings = this.getStateSettings(bleedState);
        if (MiscUtils.generateChange((double)settings.getChance().floatValue() * (1.0 - scratchMod / 100.0)) && !ph.getHealth().get((Object)bleedState).booleanValue()) {
            ph.setBleeding(bleedState, true);
        }
        if (!(entity instanceof Player) && MiscUtils.generateChange((double)(inf = this.getStateSettings(HealthStates.INFECTION)).getChance().floatValue() * (1.0 - biteMod / 100.0))) {
            ph.setInfection(HealthStates.INFECTION, true);
        }
    }

    public void bulletHitPlayer(Player player, BulletResult bulletResult) {
        PlayerHealth ph = this.playerHealthMap.get(player);
        ZEEquipmentsManager.EquipmentInventory eqInv = ZEEquipmentsManager.playerEquipmentInventories.get(player);
        double scratchMod = eqInv != null ? eqInv.getScratchProtection() : 0.0;
        switch (bulletResult.bodyPart) {
            case HEAD: {
                StateSettings s = this.getStateSettings(HealthStates.NECK_BLEEDING);
                if (!MiscUtils.generateChange((double)s.getChance().floatValue() * (1.0 - scratchMod / 100.0))) break;
                ph.setBleeding(HealthStates.NECK_BLEEDING, true);
                break;
            }
            case BODY: {
                Collections.shuffle(BleedingHandler.upperBodyPartStates);
                HealthStates s = BleedingHandler.upperBodyPartStates.get(MiscUtils.globalRandom.nextInt(BleedingHandler.upperBodyPartStates.size()));
                StateSettings st = this.getStateSettings(s);
                if (!MiscUtils.generateChange((double)st.getChance().floatValue() * (1.0 - scratchMod / 100.0))) break;
                ph.setBleeding(s, true);
                break;
            }
            case LEG: {
                Collections.shuffle(BleedingHandler.lowerBodyPartStates);
                HealthStates s = BleedingHandler.lowerBodyPartStates.get(MiscUtils.globalRandom.nextInt(BleedingHandler.lowerBodyPartStates.size()));
                StateSettings st = this.getStateSettings(s);
                if (!MiscUtils.generateChange((double)st.getChance().floatValue() * (1.0 - scratchMod / 100.0))) break;
                ph.setBleeding(s, true);
            }
        }
    }

    public void playerFall(EntityDamageEvent event, Player player) {
        double damage = event.getDamage();
        StateSettings brokenLeg = this.getStateSettings(HealthStates.BROKEN_LEG_LEFT);
        if (damage > brokenLeg.damage && MiscUtils.generateChange(brokenLeg.chance.floatValue())) {
            PlayerHealth ph = this.playerHealthMap.get(player);
            Collections.shuffle(BrokenLegHandler.legStates);
            HealthStates leg1 = BrokenLegHandler.legStates.get(0);
            HealthStates leg2 = BrokenLegHandler.legStates.get(1);
            if (!ph.getHealth().get((Object)leg1).booleanValue()) {
                ph.setBrokenLeg(leg1, true);
            } else if (!ph.getHealth().get((Object)leg2).booleanValue()) {
                ph.setBrokenLeg(leg2, true);
            }
        }
    }

    public void cureBleeding(Player player) {
        PlayerHealth ph = this.getPlayerHealth(player);
        for (HealthStates s : BleedingHandler.bleedingStates) {
            if (!Boolean.TRUE.equals(ph.getHealth().get((Object)s))) continue;
            ph.setBleeding(s, false);
            break;
        }
    }

    public void cureInfection(Player player) {
        PlayerHealth ph = this.getPlayerHealth(player);
        ph.setInfection(HealthStates.INFECTION, false);
    }

    public void cureBrokenLeg(Player player) {
        PlayerHealth ph = this.playerHealthMap.get(player);
        Collections.shuffle(BrokenLegHandler.legStates);
        for (HealthStates leg : BrokenLegHandler.legStates) {
            if (!ph.getHealth().get((Object)leg).booleanValue()) continue;
            ph.setBrokenLeg(leg, false);
            break;
        }
    }

    public void onPlayerJoin(Player player) {
        PlayerHealth ph = new PlayerHealth(player);
        this.playerHealthMap.put(player, ph);
        this.loadPlayerStates(player);
        ZEScoreBoardManager.setScoreBoardPlayer(player);
    }

    public void onPlayerLeave(Player player) {
        this.savePlayerStates(player);
        PlayerHealth ph = this.playerHealthMap.remove(player);
        if (ph != null) {
            ph.drop = true;
        }
    }

    public void resetPlayerStats(Player player) {
        PlayerHealth ph = this.playerHealthMap.get(player);
        for (HealthStates s : HealthStates.values()) {
            ph.setState(s, false);
        }
        ph.setThirstAmount(ZombiEraSettings.PLAYER_THIRST_MAX);
        ZEScoreBoardManager.setScoreBoardPlayer(player);
    }

    public void onPlayerDeath(Player player) {
        this.resetPlayerStats(player);
        PlayerHealth ph = this.playerHealthMap.get(player);
        if (ph.isInfected().booleanValue()) {
            ZombiEraCore.getEntityManager().summonEntity("walker", player.getLocation());
        }
    }

    public void addBlueprint(Player player, String bpDirName) {
        String path = String.format("/players/states/%s.yml", player.getUniqueId());
        File file = new File(ZombiEraCore.instance.getDataFolder(), path);
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        if (!config.isSet("name")) {
            return;
        }
        PlayerHealth ph = this.playerHealthMap.get(player);
        if (ph.knownBlueprints.contains(bpDirName)) {
            return;
        }
        config.set("blueprints." + bpDirName + ".enabled", (Object)true);
        ph.knownBlueprints.add(bpDirName);
        try {
            config.save(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadPlayerStates(Player player) {
        ConfigurationSection section;
        ItemBase base;
        String path = String.format("/players/states/%s.yml", player.getUniqueId());
        File file = new File(ZombiEraCore.instance.getDataFolder(), path);
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        if (!config.isSet("name")) {
            ZombiEraCore.getSpawnManager().spawnPlayerAtSpawn(player);
            this.savePlayerStates(player);
            this.loadPlayerStates(player);
            return;
        }
        PlayerHealth ph = this.playerHealthMap.get(player);
        for (HealthStates s : HealthStates.values()) {
            boolean enabled = config.getBoolean(s.toString().toLowerCase(), false);
            if (!enabled) continue;
            ph.setState(s, true);
        }
        ph.setThirstAmount(config.getInt("thirst", ZombiEraSettings.PLAYER_THIRST_MAX.intValue()));
        ph.setBalance(config.getDouble("balance", 0.0));
        PlayerStats stats = ph.getPlayerStats();
        stats.setStats(config.getInt("stats.kills.zombie", 0), config.getInt("stats.kills.player", 0));
        ZEEquipmentsManager.EquipmentInventory eqInv = ZEEquipmentsManager.addInventoryManually(player);
        int nbtId = config.getInt("backpack-nbt-id", 0);
        int bpId = config.getInt("backpack-id", -2);
        if (nbtId != 0 && bpId != -2 && (base = ZombiEraCore.getItemManager().getItemBase(nbtId)) instanceof EquitableItemBase) {
            EquitableItemBase eq = (EquitableItemBase)base;
            if (eq.type.equals((Object)EquitableTypes.BACKPACK)) {
                ItemStack backpack = eq.createItem();
                ZombiEraCore.getBackpackManager().setBackpackID(backpack, bpId);
                eqInv.setBackPack(backpack);
                eqInv.setItems();
            }
        }
        ph.knownBlueprints.clear();
        if (config.isSet("blueprints") && (section = config.getConfigurationSection("blueprints")) != null) {
            for (String key : section.getKeys(false)) {
                if (!config.getBoolean("blueprints." + key + ".enabled")) continue;
                ph.knownBlueprints.add(key);
            }
        }
        try {
            config.save(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void savePlayerStates(Player player) {
        String path = String.format("/players/states/%s.yml", player.getUniqueId());
        File file = new File(ZombiEraCore.instance.getDataFolder(), path);
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        config.set("name", (Object)player.getName());
        PlayerHealth ph = this.playerHealthMap.get(player);
        Map<HealthStates, Boolean> states = ph.getHealth();
        for (Map.Entry<HealthStates, Boolean> e : states.entrySet()) {
            config.set(e.getKey().toString().toLowerCase(), (Object)e.getValue());
        }
        config.set("thirst", (Object)ph.getThirstAmount());
        config.set("balance", (Object)ph.getBalance());
        ZombiEraCore.debugInfo(ph.getBalance().toString());
        PlayerStats stats = ph.getPlayerStats();
        config.set("stats.kills.zombie", (Object)stats.zombieKills);
        config.set("stats.kills.player", (Object)stats.playerKills);
        ZEEquipmentsManager.EquipmentInventory eqInv = ZEEquipmentsManager.playerEquipmentInventories.get(player);
        if (eqInv != null && eqInv.getBackPack() != null && eqInv.getBackPack().hasItemMeta() && eqInv.getBackPack().getItemMeta().hasCustomModelData()) {
            ItemBase base = ZombiEraCore.getItemManager().getItemBase(eqInv.getBackPack().getItemMeta().getCustomModelData());
            if (base instanceof EquitableItemBase) {
                EquitableItemBase eq = (EquitableItemBase)base;
                if (eq.type.equals((Object)EquitableTypes.BACKPACK)) {
                    int nbtId = eqInv.getBackPack().getItemMeta().getCustomModelData();
                    int bpId = ZombiEraCore.getBackpackManager().getID(eqInv.getBackPack());
                    config.set("backpack-nbt-id", (Object)nbtId);
                    config.set("backpack-id", (Object)bpId);
                }
            }
        } else {
            config.set("backpack-nbt-id", (Object)0);
            config.set("backpack-id", (Object)-2);
        }
        try {
            config.save(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

