/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.player.states.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.immersion.ZEGoreManager;
import zombieworldproject.zombieracore.managers.player.ZEScoreBoardManager;
import zombieworldproject.zombieracore.managers.player.states.HealthStateHandlerBase;
import zombieworldproject.zombieracore.managers.player.states.HealthStates;
import zombieworldproject.zombieracore.managers.player.states.PlayerHealth;
import zombieworldproject.zombieracore.managers.player.states.StateSettings;
import zombieworldproject.zombieracore.managers.player.states.ZEStateManager;

public class BleedingHandler
extends HealthStateHandlerBase {
    public static final List<HealthStates> bleedingStates = new ArrayList<HealthStates>(){
        {
            this.add(HealthStates.NECK_BLEEDING);
            this.add(HealthStates.CHEST_BLEEDING);
            this.add(HealthStates.HAND_BLEEDING_LEFT);
            this.add(HealthStates.HAND_BLEEDING_RIGHT);
            this.add(HealthStates.LEG_BLEEDING_LEFT);
            this.add(HealthStates.LEG_BLEEDING_RIGHT);
        }
    };
    public static final List<HealthStates> upperBodyPartStates = new ArrayList<HealthStates>(){
        {
            this.add(HealthStates.CHEST_BLEEDING);
            this.add(HealthStates.HAND_BLEEDING_LEFT);
            this.add(HealthStates.HAND_BLEEDING_RIGHT);
        }
    };
    public static final List<HealthStates> lowerBodyPartStates = new ArrayList<HealthStates>(){
        {
            this.add(HealthStates.LEG_BLEEDING_LEFT);
            this.add(HealthStates.LEG_BLEEDING_RIGHT);
        }
    };
    private boolean bleeding = false;

    public BleedingHandler(PlayerHealth playerHealth) {
        super(playerHealth);
    }

    public static boolean isBleedingState(HealthStates state) {
        return bleedingStates.contains((Object)state);
    }

    @Override
    public Boolean isRunning() {
        return this.bleeding;
    }

    @Override
    public void setState(HealthStates state, Boolean enabled) {
        this.playerHealth.getHealth().put(state, enabled);
        if (!this.isRunning().booleanValue()) {
            this.runStates();
        }
        this.onStateChange();
    }

    @Override
    public void onStateChange() {
        ZEScoreBoardManager.setScoreBoardPlayer(this.playerHealth.getPlayer());
    }

    public void runStates() {
        if (this.bleeding) {
            return;
        }
        this.bleeding = true;
        final ZEStateManager manager = ZombiEraCore.ZEPlayerManagers.getHealthManager();
        new BukkitRunnable(){

            public void run() {
                Player player = BleedingHandler.this.playerHealth.getPlayer();
                if (!player.isOnline()) {
                    this.cancel();
                    return;
                }
                boolean bleedingNow = false;
                Random rand = new Random();
                for (HealthStates state : bleedingStates) {
                    StateSettings settings = manager.getStateSettings(state);
                    int tickNext = BleedingHandler.this.playerHealth.timerTick(state);
                    boolean enabled = Boolean.TRUE.equals(BleedingHandler.this.playerHealth.getHealth().get((Object)state));
                    if (enabled && tickNext > settings.getTimer()) {
                        player.damage(settings.getDamage().doubleValue());
                        BleedingHandler.this.playerHealth.resetTimer(state);
                        ZEGoreManager.playerBleed(player);
                        for (int i = 0; i < rand.nextInt(4) + 2; ++i) {
                            Location loc = player.getLocation().clone();
                            if (rand.nextBoolean()) {
                                loc.add((double)(rand.nextFloat() / 2.0f), (double)(rand.nextFloat() / 2.0f), (double)(rand.nextFloat() / 2.0f));
                            } else {
                                loc.add((double)(-rand.nextFloat() / 2.0f), (double)(-rand.nextFloat() / 2.0f), (double)(-rand.nextFloat() / 2.0f));
                            }
                            Particle.DustTransition dustTransition = new Particle.DustTransition(Color.fromRGB((int)255, (int)0, (int)0), Color.fromRGB((int)100, (int)0, (int)0), 1.0f);
                            player.getWorld().spawnParticle(Particle.DUST_COLOR_TRANSITION, loc, 30, (Object)dustTransition);
                        }
                        if (!BleedingHandler.this.playerHealth.isUsingItem().booleanValue()) {
                            ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "You are bleeding!", 5);
                        }
                    }
                    if (!enabled) continue;
                    bleedingNow = true;
                }
                if (!bleedingNow) {
                    BleedingHandler.this.onStateChange();
                    BleedingHandler.this.bleeding = false;
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 1L, 5L);
    }
}

