/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.player.states.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.player.ZEScoreBoardManager;
import zombieworldproject.zombieracore.managers.player.states.HealthStateHandlerBase;
import zombieworldproject.zombieracore.managers.player.states.HealthStates;
import zombieworldproject.zombieracore.managers.player.states.PlayerHealth;

public class BrokenLegHandler
extends HealthStateHandlerBase {
    public static final List<HealthStates> legStates = new ArrayList<HealthStates>(){
        {
            this.add(HealthStates.BROKEN_LEG_LEFT);
            this.add(HealthStates.BROKEN_LEG_RIGHT);
        }
    };
    private boolean broken = false;

    public BrokenLegHandler(PlayerHealth playerHealth) {
        super(playerHealth);
    }

    @Override
    public Boolean isRunning() {
        return this.broken;
    }

    @Override
    public void setState(HealthStates state, Boolean enabled) {
        this.playerHealth.getHealth().put(state, enabled);
        if (!this.isRunning().booleanValue()) {
            this.runStates();
        }
        this.onStateChange();
    }

    @Override
    public void onStateChange() {
        ZEScoreBoardManager.setScoreBoardPlayer(this.playerHealth.getPlayer());
    }

    public void runStates() {
        if (this.broken) {
            return;
        }
        this.broken = true;
        final Map<HealthStates, Boolean> states = this.playerHealth.getHealth();
        new BukkitRunnable(){

            public void run() {
                Player player = BrokenLegHandler.this.playerHealth.getPlayer();
                if (!player.isOnline()) {
                    this.cancel();
                    return;
                }
                int multiplier = 0;
                if (Boolean.TRUE.equals(states.get((Object)HealthStates.BROKEN_LEG_LEFT))) {
                    ++multiplier;
                }
                if (Boolean.TRUE.equals(states.get((Object)HealthStates.BROKEN_LEG_RIGHT))) {
                    multiplier += multiplier > 0 ? 2 : 1;
                }
                if (multiplier == 0) {
                    BrokenLegHandler.this.broken = false;
                    BrokenLegHandler.this.onStateChange();
                    this.cancel();
                    return;
                }
                player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 10, multiplier));
                if (!BrokenLegHandler.this.playerHealth.isUsingItem().booleanValue()) {
                    ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "You have broken leg!", 5);
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 1L, 5L);
    }
}

