/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.player.states.handlers;

import java.util.Random;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.player.ZEScoreBoardManager;
import zombieworldproject.zombieracore.managers.player.states.HealthStateHandlerBase;
import zombieworldproject.zombieracore.managers.player.states.HealthStates;
import zombieworldproject.zombieracore.managers.player.states.PlayerHealth;
import zombieworldproject.zombieracore.managers.player.states.StateSettings;
import zombieworldproject.zombieracore.managers.player.states.ZEStateManager;

public class InfectionHandler
extends HealthStateHandlerBase {
    private boolean infected = false;

    public InfectionHandler(PlayerHealth playerHealth) {
        super(playerHealth);
    }

    @Override
    public Boolean isRunning() {
        return this.infected;
    }

    @Override
    public void setState(HealthStates state, Boolean enabled) {
        this.playerHealth.getHealth().put(state, enabled);
        if (!this.isRunning().booleanValue()) {
            this.runStates();
        }
        this.onStateChange();
    }

    @Override
    public void onStateChange() {
        ZEScoreBoardManager.setScoreBoardPlayer(this.playerHealth.getPlayer());
    }

    public void runStates() {
        if (this.infected) {
            return;
        }
        this.infected = true;
        final ZEStateManager manager = ZombiEraCore.ZEPlayerManagers.getHealthManager();
        new BukkitRunnable(){

            public void run() {
                if (!InfectionHandler.this.playerHealth.getPlayer().isOnline()) {
                    this.cancel();
                    return;
                }
                Player player = InfectionHandler.this.playerHealth.getPlayer();
                StateSettings settings = manager.getStateSettings(HealthStates.INFECTION);
                int tickNext = InfectionHandler.this.playerHealth.timerTick(HealthStates.INFECTION);
                boolean enabled = InfectionHandler.this.playerHealth.getHealth().get((Object)HealthStates.INFECTION);
                if (tickNext > settings.getTimer()) {
                    if (player.getHealth() > settings.getDamage()) {
                        player.damage(settings.getDamage().doubleValue());
                    }
                    InfectionHandler.this.playerHealth.resetTimer(HealthStates.INFECTION);
                    Random rand = new Random();
                    for (int i = 0; i < rand.nextInt(4) + 2; ++i) {
                        Location loc = player.getLocation().clone();
                        if (rand.nextBoolean()) {
                            loc.add((double)(rand.nextFloat() / 2.0f), (double)(rand.nextFloat() / 2.0f), (double)(rand.nextFloat() / 2.0f));
                        } else {
                            loc.add((double)(-rand.nextFloat() / 2.0f), (double)(-rand.nextFloat() / 2.0f), (double)(-rand.nextFloat() / 2.0f));
                        }
                        Particle.DustTransition dustTransition = new Particle.DustTransition(Color.fromRGB((int)0, (int)255, (int)0), Color.fromRGB((int)144, (int)238, (int)144), 1.0f);
                        player.spawnParticle(Particle.DUST_COLOR_TRANSITION, loc, 30, (Object)dustTransition);
                    }
                    if (!InfectionHandler.this.playerHealth.isUsingItem().booleanValue()) {
                        ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "You are infected!", 5);
                    }
                }
                if (!enabled) {
                    InfectionHandler.this.infected = false;
                    InfectionHandler.this.onStateChange();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 1L, 5L);
    }
}

